#include "dshot.h"



uint8_t dshotCmdBuffer[DSHOT_BUFFER_LENGTH];
uint16_t prevDshotThrottle = 0;
bool dshotThrottleChange = false;

void resetDshotThrottleChange(void){
    dshotThrottleChange = false;
}

bool checkDshotThrottleChange(void){
    return dshotThrottleChange;
}

uint16_t getDshotThrottle(void){
    return prevDshotThrottle;
}
    
uint8_t calcDshotCRC(uint16_t dshotPacket){
    uint8_t crc = 0;
    
    for (int i = 0; i<3; i++) {
        crc ^= dshotPacket;
        dshotPacket >>= 4;
    }
    
    crc &= 0xf;
    return crc;
}

void setupDshotCmdBuffer(uint16_t dshotCmd){
    uint32_t modifier = ( + DSHOT_CLK / 2) / DSHOT_CLK;
    memset(dshotCmdBuffer, 0 , DSHOT_BUFFER_LENGTH);
    
    for(int i=0; i<DSHOT_CMD_LENGTH; i++){ // scan all the bits in the packet
        if( (bool)((1 << i) & dshotCmd)){
            dshotCmdBuffer[15-i] = (modifier * DSHOT_1_TIME) >> 8; // pack buffer MSB first
        } else {
            dshotCmdBuffer[15-i] = (modifier * DSHOT_0_TIME) >> 8; // pack buffer MSB first
        }
    }
}

void dshotOutput(uint16_t dshotValue){
    uint16_t packet = 0;
    uint8_t crc = 0;
    
    //checks bounds for dshot throttle value
    if (dshotValue < 48) dshotValue = 48;
    else if (dshotValue > 2047) dshotValue = 2047;
    
    packet = dshotValue << 1;
    crc = calcDshotCRC(packet);
    packet = (packet << 4) | crc;
    setupDshotCmdBuffer(packet);
    //writeDshotCmd();
}

void setDshotThrottle(uint16_t throttle){
    prevDshotThrottle = throttle;
    dshotThrottleChange = true;
    dshotOutput(prevDshotThrottle + 48);
}