#include "mbed.h"
#include "math.h"
#include "SDFileSystem.h"

/*AE-GYSFDMAXBとAE-MICRO-SD-DIPを使用*/

SDFileSystem sd(p5,p6,p7,p8,"sd"); 

#define TIME_GAP      6.0   

Serial           gps(p9,p10);   //ピンを指定

Timer  timer_open;
Timer  timer_log;
Ticker tic_open;
Ticker tic_log;

float   _DMS2DEG(float raw_data);
int     _input(char cha);

float Time;
char  gps_data[256];
int   cnt_gps;
int   Cnt_GPS=0;

int main(){
    
    mkdir("/sd/mydir", 0777);//ディレクトリ作成
    
    while(1){     
        if(gps.readable()){
            gps_data[cnt_gps] = gps.getc();
            if(gps_data[cnt_gps] == '$' || cnt_gps ==256){
                cnt_gps = 0;
                memset(gps_data,'\0',256);
            }else if(gps_data[cnt_gps] == '\r'){
                float world_time, lon_east, lat_north;
                int rlock, sat_num;
                char lat,lon;
                if(sscanf(gps_data,"GPGGA,%f,%f,%c,%f,%c,%d,%d",&world_time,&lat_north,&lat,&lon_east,&lon,&rlock,&sat_num)>=1){
                    
                    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");//ファイルを開いて追加書き込み
                        if(fp == NULL) {
                            error("Could not open file for write\n");
                        }
                    
                    if(rlock==1){
                        lat_north = _DMS2DEG(lat_north);
                        lon_east = _DMS2DEG(lon_east);
                                      
                        fprintf(fp,"%s\r\n",gps_data);
                        fprintf(fp,"Lat:%f,Lon:%f\r\ntime:%f,sat_num:%d\r\n",lat_north,lon_east,world_time,sat_num);
                    }else{
                        fprintf(fp,"%s\r\n",gps_data);
                    }
                    fclose(fp);//ファイルを閉じる
                }
            }else{
                cnt_gps++;
            }

        }
        if(timer_log.read()>=30.0*60.0) timer_log.reset();
    }
}

float _DMS2DEG(float raw_data){
    int d=(int)(raw_data/100);
    float m=(raw_data-(float)d*100);
    return (float)d+m/60;
}