#include "mbed.h"
#include "MMA8452.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "PinDetect.h"
#include <vector>
#include <string>
#include <algorithm>

Serial pc(USBTX, USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card DI, DO, SCK, CS
uLCD_4DGL uLCD(p9, p10, p11); // create a global uLCD object rx, tx, reset
MMA8452 acc(p28, p27, 100000); // SDA, SCL, rate
AnalogOut DACout(p18);
PwmOut PWMout(p21);
wave_player waver(&DACout,&PWMout);
PinDetect pb1(p30);


enum modes_t {MainMenu, ListArtists, ListSongs, ListSongsByArtist, PlaySong, PauseSong};
modes_t Mode;
volatile unsigned short currentPointer = 0;
char filePath[] = "/sd/myMusic/";
char location;
vector<string> filenames;
vector<string> artistNames;
vector<string> songNames;
vector<string> playList;
FILE *wave_file;
string artistChosen = "";
string songChosen = "";
int x_value, y_value, z_value;
bool playing = true;
float volume = 0.5f;
float volume_change = 1;

void VolumeUp() {
    volume_change += 0.05;
    if (volume_change >= 1.5) {
        volume_change = 2;
    }
}
void VolumeDown() {
    volume_change -= 0.05;
    if (volume_change <= 0.0) {
        volume_change = 0.0;
    }
}

void pb1_hit_callback()
{
    
    if (Mode == PauseSong) {
        Mode = MainMenu;
    } else {
        playing = !playing;
    }
}

void playSong(string filename) //play a song of given filename
{
    wave_file = fopen(filename.c_str(),"r");
    waver.play(wave_file);
    fclose(wave_file);
}


int aa = 0;

void read_file_names(char *dir) {
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    filenames.clear();
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
}

void printArtists(vector<string> inputList) {
    uLCD.cls();
    uLCD.locate(0,0);
    uLCD.printf("LIST OF ARTISTS:");
    for (int x = 0; x < inputList.size();x++)
    {
        size_t index = inputList[x].find("-");
        uLCD.locate(2,x+3);
        uLCD.printf(inputList[x].substr(0,index).c_str());
    }    
    uLCD.locate(0,currentPointer+3);
    uLCD.printf("->");
}

void printSongs(vector<string> inputList) {
    uLCD.cls();
    uLCD.locate(0,0);
    uLCD.printf("LIST OF SONGS:");
    for (int x = 0; x < inputList.size();x++)
    {
        size_t index = inputList[x].find("-");
        uLCD.locate(2,x+3);
        uLCD.printf(inputList[x].substr(index+2,inputList[x].length()).c_str());
    }    
    uLCD.locate(0,currentPointer+3);
    uLCD.printf("->");
}

vector<string> getArtistList(vector<string> filenames) {
    vector<string> returnList;
    bool mark = false;
    
    for (int i = 0; i < filenames.size(); i++) {
        size_t index = filenames[i].find("-");
        for (int j = i + 1; j < filenames.size(); j++) {
            if (filenames[i].substr(0,index).compare(filenames[j].substr(0,index)) == 0) {
                mark = true;
            }
        }
        
        if (mark == false) {
            returnList.push_back(filenames[i]);
        }
        
        mark = false;
    }
    
    return returnList;
}

vector<string> getSongList(vector<string> filenames) {
    vector<string> returnList;
    for (int i = 0; i < filenames.size(); i++) {
        size_t index = filenames[i].find("-");
        returnList.push_back(filenames[i]);
    }
    return returnList;
}

vector<string> getSongsByArtistList(vector<string> filenames, string artistName) {
    vector<string> returnList;
    for (int i = 0; i < filenames.size(); i++) {
        size_t index = filenames[i].find("-");
        if (filenames[i].find(artistName) != string::npos) {
            returnList.push_back(filenames[i]);
        }
    }
    return returnList;
}


int main() {
    
    pb1.mode(PullUp);
    pb1.attach_deasserted(&pb1_hit_callback);
    pb1.setSampleFrequency();
    Mode = MainMenu;    
    acc.activate();
    
    PWMout.period(1.0/400000.0);
    
    while (1) {
        if (Mode == MainMenu) {
            uLCD.cls();
            uLCD.locate(0,0);
            uLCD.printf("Please Choose:");
            uLCD.locate(0,7);
            uLCD.printf("Artists");
            uLCD.locate(12,7);
            uLCD.printf("Songs");
            while (x_value < 700 && x_value > -700) {
                acc.readXCount(&x_value);
                if (x_value > 700) {
                    Mode = ListArtists; //+X for artists
                }
                if (x_value < -700) {
                    Mode = ListSongs; //-X for Songs
                }
            }
            
        }
        
        if (Mode == ListArtists) {
            read_file_names("/sd/myMusic");
            uLCD.cls();
            artistNames = getArtistList(filenames);
            printArtists(artistNames); //same thing as printSongs(); but for artists
            
            while ( x_value < 700 ||  x_value > -700 || y_value < 700 || y_value > -700)
            {
                
                acc.readYCount(&y_value);
                acc.readXCount(&x_value);
                
                if (y_value > 700) {
                    Mode = MainMenu; //+Y for main menu.
                    break;
                }
                if (y_value < -700) {
                    Mode = ListSongsByArtist; //-Y to list songs by artists
                    size_t index2 = artistNames[currentPointer].find("-");
                    artistChosen = artistNames[currentPointer].substr(0,index2);
                    break;
                }
                if (x_value > 700) {
                    if (currentPointer <= 0) {
                        currentPointer--;
                        break;
                    }
                }
                if (x_value <-700) {
                    if (currentPointer != artistNames.size()) {
                        currentPointer++;
                        break;
                    }
                }
            }
        }
        
        if (Mode == ListSongs) {
            uLCD.cls();
            read_file_names("/sd/myMusic");
            songNames = getSongList(filenames);
            printSongs(songNames);
            uLCD.locate(0,0);
            
            while ( x_value < 700 ||  x_value > -700 || y_value < 700 || y_value > -700)
            {
                
                acc.readXCount(&x_value);
                acc.readYCount(&y_value);
                
                if (y_value > 700) {
                    Mode = MainMenu; //+Y to go back to the main menu.
                    break;
                }
                if (y_value < -700) {
                    playList = songNames;
                    Mode = PlaySong; //-Y to play the song.
                    break;
                }
                if (x_value > 700) {
                    if (currentPointer != 0) {
                        currentPointer--;
                        break;
                    }
                }
                if (x_value <-700) {
                    if (currentPointer != songNames.size()) {
                        currentPointer++; 
                        break;
                    }
                }
                //
//                //Debug Status
//                uLCD.locate(9,9);
//                uLCD.printf("X: %d", x_value);
//                uLCD.locate(9,10);
//                uLCD.printf("Y: %d", y_value);
            }
        }
        
        if (Mode == ListSongsByArtist) {
            uLCD.cls();
            read_file_names("/sd/myMusic");
            songNames = getSongsByArtistList(filenames, artistChosen);
            printSongs(songNames);
            uLCD.locate(0,0);
            uLCD.printf("ListSongsByArtist:");
            
            while ( x_value < 700 ||  x_value > -700 || y_value < 700 || y_value > -700)
            {
                
                acc.readXCount(&x_value);
                acc.readYCount(&y_value);
                
                if (y_value > 700) {
                    Mode = ListArtists; //+Y to go back to list artists
                    break;
                }
                if (y_value < -700) {
                    playList = songNames;
                    Mode = PlaySong; //-Y to play the song.
                    break;
                }
                if (x_value > 700) {
                    if (currentPointer >= 0) {
                        currentPointer--; ////this decreases the song counter (used for selection)
                        break;
                    }
                }
                if (x_value <-700) {
                    if (currentPointer <= songNames.size()) {
                        currentPointer++; ////this increases the song counter
                        break;
                    }
                }
            }
        }
        
        if (Mode == PlaySong) {
            uLCD.cls();
            size_t index3 = playList[currentPointer].find("-");
            uLCD.locate(0,2);
            uLCD.printf("Now Playing:");
            uLCD.locate(2,4);
            uLCD.printf(playList[currentPointer].substr(0,index3).c_str());
            uLCD.locate(2,6);
            uLCD.printf(playList[currentPointer].substr(index3+2, playList[currentPointer].length()-4).c_str());
            playing = true;
            if (playing) {
                playSong("/sd/myMusic/" + playList[currentPointer]);
            }
            Mode = PauseSong;
        }
        
        if (Mode == PauseSong) {
            uLCD.cls();
            uLCD.locate(2,2);
            uLCD.printf("Song Stopped.");
            uLCD.locate(2,4);
            uLCD.printf("Volume: %d", (int)(volume_change * 100/150*100) );
            
            while ( x_value < 700 ||  x_value > -700 || y_value < 700 || y_value > -700)
            {
                
                acc.readXCount(&x_value);
                acc.readYCount(&y_value);
                
                if (x_value > 700) {
                    VolumeUp();
                    break;
                }
                if (x_value < -700) {
                    VolumeDown();
                    break;
                }
                if (y_value > 700) {
                    //Change
                    currentPointer++;
                    songChosen = playList[currentPointer];
                    Mode = PlaySong;
                    break;
                }
                if (y_value <-700) {
                    
                    currentPointer--;
                    songChosen = playList[currentPointer];
                    //Change to previous song
                    Mode = PlaySong;
                    break;
                }
                
                if (Mode == MainMenu) {
                    break;
                }
            }
            
        }
                
    }
}
