#include "LSM9DS1.h"
#include "uLCD_4DGL.h"
#include <stdlib.h>
#include <time.h>
#include "wave_player.h"
#include "SDFileSystem.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
uLCD_4DGL uLCD(p9,p10,p11);
Serial pc(USBTX, USBRX);
AnalogOut mySpeaker(p18);  //speaker
wave_player player(&mySpeaker);                // wav player
//
//
int main() {
//    

srand(time(NULL));
float hole_x = rand() % 98 + 31;
float hole_y = rand() % 98 + 31;
float ball_x = 64;
float ball_y = 64;

    LSM9DS1 imu(p28, p27, 0xD6, 0x3C);
    imu.begin();
    imu.calibrate();
    int score = 0;
    int timer = 100;
    bool win = false;
    bool lose = false;
    int starttime = 10;
    uLCD.baudrate(BAUD_3000000);
    FILE *wave_file2;
    FILE *wave_file3;
    volatile bool playStop = false;
    volatile unsigned short volume = 0;
//

        uLCD.locate(1,0);
        uLCD.printf("Ball In the Hole");
        uLCD.locate(2,4);
        uLCD.printf("Roll ball into");
        uLCD.locate(3,5);
        uLCD.printf("hole 10 times");
        uLCD.locate(4,6);
        uLCD.printf("before time");
        uLCD.locate(5,7);
        uLCD.printf("runs out!");
        while (1) {
            uLCD.locate(1,10);
            uLCD.printf("Game starts in:%d ", starttime);
            starttime--;
            wait(0.5);
            if (starttime == 0) break;
        }

    uLCD.cls();
    while (1) {
        srand(time(NULL));
        uLCD.circle(hole_x, hole_y, 15, BLUE);
        uLCD.filled_circle(ball_x, ball_y, 9, BLACK);
        imu.readAccel();
        ball_x = -imu.calcAccel(imu.ax) * 64 + 64;
        ball_y = -imu.calcAccel(imu.ay) * 64 + 64;   
        uLCD.filled_circle(ball_x, ball_y, 9, RED);
        uLCD.locate(0,0);
        uLCD.printf("Score:%d ", score);
        uLCD.locate(9,0);
        uLCD.printf("Time:%d ", timer);
        timer--;
        
        if (ball_x > hole_x - 6 && ball_x < hole_x + 6 && ball_y > hole_y - 6 && ball_y < hole_y + 6) {
                score++;
                uLCD.circle(hole_x, hole_y, 15, BLACK);
                hole_x = rand() % 98 + 1;
                hole_y = rand() % 98 + 1;
        }  
        
         if (score == 10) {
            win = true;
            break;
         }
         
         if (timer <= 0) {
            lose = true;
            break;
         }
        
    }
    
    if (win) {
        uLCD.cls();
        uLCD.media_init();
        uLCD.set_sector_address(0x0000, 0x0235);
        uLCD.display_video(0,0);
        wave_file2 = fopen("/sd/wavfiles/win.wav","r");
        player.play(wave_file2);
        fclose(wave_file2);
    }
    
    if (lose) {
        uLCD.cls();
        uLCD.media_init();
        uLCD.set_sector_address(0x0000, 0x01F4);
        uLCD.display_video(0,0);
        //PlayGIF
        wave_file3 = fopen("/sd/wavfiles/lose.wav","r");
        player.play(wave_file3);
        fclose(wave_file3);
        //PlaySound
    }
    
}
