#include "SimpleRGB.h"


// construct a LightColor object
LightColor::LightColor(float r, float g, float b)
    : red(r), green(g), blue(b)
{
}

// construct an RGBLed object
RGBLed::RGBLed(PinName rpin, PinName gpin, PinName bpin)
    : _rpin(rpin), _gpin(gpin), _bpin(bpin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _rpin.period(0.0005);
}

// write directly to an RGBLed object
void RGBLed::write(float red, float green, float blue) {
    _rpin = red;
    _gpin = green;
    _bpin = blue;
}

// use a LightColor object to change the RGBLed
void RGBLed::write(LightColor color) {
    _rpin = color.red;
    _gpin = color.green;
    _bpin = color.blue;
}