#ifndef SIMPLERGB_H
#define SIMPLERGB_H

#include "mbed.h"

class LightColor
{
    public:
        LightColor(float r, float g, float b);
        float red;
        float green;
        float blue;
};

class RGBLed
{
    public:
        RGBLed(PinName rpin, PinName gpin, PinName bpin);
        void write(float red, float green, float blue);
        void write(LightColor color);
        RGBLed operator = (LightColor color) {
            write(color);
            return *this;
        };
        
    private:
        PwmOut _rpin;
        PwmOut _gpin;
        PwmOut _bpin;
};

#endif
    
        
    