#include "mbed.h"
#include "rtos.h"
#include <string>
#include "uLCD_4DGL.h"
#include "SimpleRGB.h"
#include "SDFileSystem.h"
#include "wave_player.h"

#define SECOND 1000 // used with threads
DigitalOut led(LED1); // test led


/* 1 init/declare

Ticker first;
Ticker second;
Ticker third;
Ticker fourth;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

void one() {      // attached to ticker object. will be called after time given
    led1 = !led1; // flip the value of the led
}                 // nothing returned

void two() {
    led2 = !led2;
}

void three() {
    led3 = !led3;
}

void four() {
    led4 = !led4;
}

*/// - 1


/* 2 init/declare */

uLCD_4DGL lcd(p9, p10, p11); // lcd used by the following threads
Mutex stdio_mutex;           // mutex lock, ensure safe use of lcd

// lcd thread
void uLCD_reboot_thread(void const *args) {
    // show reboot process, associated with clip of apple restart
    while (true) {
        // lock, print 'Rebooting!' to uLCD with "progress_bar" underneath
        stdio_mutex.lock();
        lcd.text_string("Rebooting", 2, 5, FONT_7X8, WHITE);
        // draw progress bar 8 sec
        for (int i = 0; i < 8; i++) {
            lcd.text_string("|", 2 + i, 6, FONT_7X8, WHITE);
            // progress[i+1] += arr[i];
            Thread::wait(SECOND);
        }
        // draw an ascii 'apple'
        lcd.text_string("        .:'    ", 2, 4, FONT_7X8, WHITE);
        lcd.text_string("       :'      ", 2, 5, FONT_7X8, WHITE);
        lcd.text_string(" .'`  `-'  ``. ", 2, 6, FONT_7X8, WHITE);
        lcd.text_string(":          .-' ", 2, 7, FONT_7X8, WHITE);
        lcd.text_string(":         :    ", 2, 8, FONT_7X8, WHITE);
        lcd.text_string(" :         `-; ", 2, 9, FONT_7X8, WHITE);
        lcd.text_string("  `.__.-.__.'  ", 2, 10, FONT_7X8, WHITE);
        // unlock, wait for 52
        stdio_mutex.unlock();
        Thread::wait(52 * SECOND);
        // clear screen
        stdio_mutex.lock();
        lcd.cls();
        stdio_mutex.unlock();
    }
}

// lcd thread
void uLCD_status_thread(void const *args) {
    // show time with smile, frown, sad face at top right
    set_time(1476146921);
    while (true) {
        char buffer[32];
        time_t seconds = time(NULL);
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        // lock, update time at top right with smiley at top left
        stdio_mutex.lock();
        lcd.text_string(buffer, 8, 1, FONT_7X8, BLUE);
        lcd.text_string(":-)", 1, 1, FONT_7X8, WHITE);
        // unlock, wait for 20 sec
        stdio_mutex.unlock();
        Thread::wait(20 * SECOND);
        // lock, change to frown
        stdio_mutex.lock();
        lcd.text_string(">:|", 1, 1, FONT_7X8, WHITE);
        // unlock, wait for 20 sec
        stdio_mutex.unlock();
        Thread::wait(20 * SECOND);
        // lock, change to sad
        stdio_mutex.lock();
        lcd.text_string(":-(", 1, 1, FONT_7X8, WHITE);
        // unlock, wait for 20 sec
        stdio_mutex.unlock();
        Thread::wait(20 * SECOND);        
    }
}


/* extra credit - video */
void uLCD_video_thread(void const *args) {
    lcd.media_init();
    lcd.set_sector_address(0x001D, 0x4C42);
    lcd.display_video(0,0);
}
// - extra


RGBLed rgbLED(p21, p22, p23);          // object to use the RGB LED
const LightColor green(0.0, 1.0, 0.0);
const LightColor yellow(1.0, 1.0, 0.0);
const LightColor orange(1.0, 0.6, 0.0);
const LightColor red(1.0,0.0,0.0);
const LightColor violet(1.0, 0.0, 0.8);
const LightColor blue(0.0, 0.0, 1.0);

// rgb led thread
void rainbow_led_thread(void const *args) {
    // reboot with white (6 sec), then cycle through apple colors (54 sec)
    while (true) {
        rgbLED.write(1.0, 1.0, 1.0); // bright white
        Thread::wait(2 * SECOND);
        // dim to nothing over 4 seconds
        for (float c = 1.0; c > 0.0; c = c - 0.01) {
            rgbLED.write(c, c, c);
            Thread::wait(40); // 40 * 100 = 4000 = 4 secs
        }
        // rotate through other colors over 54 seconds
        rgbLED = green;
        Thread::wait(9 * SECOND);
        rgbLED = yellow;
        Thread::wait(9 * SECOND);
        rgbLED = orange;
        Thread::wait(9 * SECOND);
        rgbLED = red;
        Thread::wait(9 * SECOND);
        rgbLED = violet;
        Thread::wait(9 * SECOND);
        rgbLED = blue;
        Thread::wait(9 * SECOND);
    }
}

SDFileSystem sd(p5, p6, p7, p8, "sd"); // SD card with .wav files
AnalogOut DACout(p18);                 // DAC for producing sound
wave_player waver(&DACout);            // wavplayer object
// - 2


int main() {
    /* 1 calls
    led1 = 1, led2 = 1, led3 = 1, led4 = 1;
    
    first.attach(&one, 1.0);   // attach the function and when to call it
    second.attach(&two, 2.0);
    third.attach(&three, 3.0);
    fourth.attach(&four, 4.0);
    */// - 1
    
    
    /* 2 calls */
    Thread thread2(uLCD_reboot_thread);
    Thread thread3(uLCD_status_thread);
    Thread thread4(rainbow_led_thread);
    //Thread thread5(uLCD_video_thread);
    
    FILE *wave_file;
    
    // - 2
    
    
    led = 1;
    
    while(true) {
        
        /* 2 speaker 'thread' calls */
        // speaker plays mac reboot sound, error sound occasionally
        // play reboot sound
        wave_file = fopen("/sd/reboot.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        // wait 20
        Thread::wait(20 * SECOND);
        // error
        wave_file = fopen("/sd/error.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        // wait 20
        Thread::wait(20 * SECOND);
        // error
        waver.play(wave_file);
        fclose(wave_file);
        // wait 20
        Thread::wait(20 * SECOND);
        // - 2
    }                // interupts will occur automatically
}
