// code for part 1, 2, & 3
#include "mbed.h"
#include "MCP23S17.h"

// 1
DigitalIn dip_switch3(p30);
DigitalOut red_led(p17);
// 2
DigitalIn dip_switch1(p28);
DigitalIn dip_switch2(p29);
PwmOut green_led(p21);
// 3
SPI spi(p5, p6, p7); // SPI bus
char Opcode = 0x40; // 8-bit address for writes
MCP23S17 chip = MCP23S17(spi, p20, Opcode); // create an MCP23S17
int switch_state;
// RGB led control
AnalogIn control_pot(p18);
PwmOut rgb_b(p22);
PwmOut rgb_r(p23);
PwmOut rgb_g(p24);
// WATCHDOG
DigitalOut myled1(LED1); //in main loop part 1
DigitalOut myled2(LED2); //in main loop part 2 (where fault occurs)
DigitalOut myled3(LED3); //The pushbutton or power on caused a reset
DigitalOut myled4(LED4); //The watchdog timer caused a reset
 
// Simon's Watchdog code from
// http://mbed.org/forum/mbed/topic/508/
class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};
Watchdog wdt;

int main()
{
    int count = 0;
// On reset, indicate a watchdog reset or a pushbutton reset on LED 4 or 3
    if ((LPC_WDT->WDMOD >> 2) & 1)
        myled4 = 1; else myled3 = 1;
        
// setup a 10 second timeout on watchdog timer hardware
// needs to be longer than worst case main loop exection time
    wdt.kick(5.0);  
    // 2
    dip_switch1.mode(PullUp); // configure internal pull up resistor
    dip_switch2.mode(PullUp);
    
    green_led.period(0.016f); // ~ 60 Hz
    green_led.write(0.50f); // 50 % duty cycle
    
    // 3
    chip.direction(PORT_A, 0x00); // set all Port A bits to output
    chip.direction(PORT_B, 0xFF); // set all B to input
    switch_state = 0;
    
    while(1) {
        // 1
        red_led = dip_switch3;
        
        // 2
        if (!dip_switch1) {
            green_led.write(0.25f); // half start brightness, half duty cycle
        }
        else if (!dip_switch2) {
            green_led.write(0.125f); // 1/4 starting brightness
        } else {
            green_led.write(0.50f); // initial
        }
        
        // 3
        // get the state of the switch (0 or 1) and flip it, 0 when off
        switch_state = !chip.read(PORT_B) & 0x01;
        // write the saved value to MCP23S17 Port A
        chip.write(PORT_A, switch_state);
        wait(.2);
        // yellow led should change opposite the green led
        if (count == 12) while (1) {};
        // LED 2 will stay on during the fault
        count ++;
        // End of main loop so "kick" to reset watchdog timer and avoid a reset
        wdt.kick();
        // RGB led control
        rgb_r = control_pot;
        rgb_g = 0.5f - control_pot;
        rgb_b = 1.0f - control_pot;
    }
}
