#include "shutter.h"

//Constructor
Shutter::Shutter()
{
}


void Shutter::init( DigitalOut* SH1_1, DigitalOut* SH1_2, DigitalOut* SH2_1, DigitalOut* SH2_2, DigitalOut* SH3_1, DigitalOut* SH3_2, DigitalOut* SH4_1, DigitalOut* SH4_2 )
{
    SH_ARR[0] = SH1_1;
    SH_ARR[1] = SH1_2;
    SH_ARR[2] = SH2_1;
    SH_ARR[3] = SH2_2;
    SH_ARR[4] = SH3_1;
    SH_ARR[5] = SH3_2;
    SH_ARR[6] = SH4_1;
    SH_ARR[7] = SH4_2;
    
    writeShutters( 0, 0, 0, 0 ); //intial State
}

void Shutter::toggleShutter( int SHnum )
{
    if (SHnum < 8 && SHnum > 0)
    {
        int a1 = *SH_ARR[ SHnum - 1];
        int a2 = *SH_ARR[ SHnum ];
        
        if ( a1 == 1 && a2 == 0 )
        {
            *SH_ARR[ SHnum - 1] = 0;
            *SH_ARR[ SHnum ] = 1;
        }
        
        else if( a1 == 0 && a2 == 1)
        {
            *SH_ARR[ SHnum - 1] = 1;
            *SH_ARR[ SHnum ] = 0;
        }
    }
}


void Shutter::writeShutters(bool SH1, bool SH2, bool SH3, bool SH4)
{
    //Shutter 1
    if( SH1)
    {
        *SH_ARR[0] = 1;
        *SH_ARR[1] = 0;   
    }
    else
    {
        *SH_ARR[0] = 0;
        *SH_ARR[1] = 1;
    }
    
    //Shutter 2
    if( SH2)
    {
        *SH_ARR[2] = 1;
        *SH_ARR[3] = 0; 
    }
    else
    {
        *SH_ARR[2] = 0;
        *SH_ARR[3] = 1;
    }
    
    //Shutter 3
    if( SH3)
    {
        *SH_ARR[4] = 1;
        *SH_ARR[5] = 0;   
    }
    else
    {
        *SH_ARR[4] = 0;
        *SH_ARR[5] = 1;
    }
    
    //Shutter 4
    if( SH4)
    {
        *SH_ARR[6] = 1;
        *SH_ARR[7] = 0;  
    }
    else
    {
        *SH_ARR[6] = 0;
        *SH_ARR[7] = 1;
    }    
}
