/** example program for the use of the MCP4728 class and DACInterface.h classes
 *
 *  V 1.0  : tested on the KL05z  but without the MCP4728 connected \
 * (C) Wim Beaumont Universiteit Antwerpen 2016 
 */ 

#define MCP4728EXAMPLEVER "2.04"
#define TARGET_MBED 1

#include "mbed.h"
#include <string>

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#elif defined (TARGET_MBED)
  PinName const SDA = p28;
  PinName const SCL = p27;
#else
  #error TARGET NOT DEFINED
#endif


#include "I2C.h"
#include "I2CInterface.h" 
#include "MBEDI2CInterface.h" 
#include "DACInterface.h" 
#include "dev_interface_def.h"
#include "MCP4728setaddr.h"
#include "mcp4728.h"

#include "shutter.h"

MBEDI2CInterface mbedi2c( SDA, SCL); 
MBEDI2CInterface* mbedi2cp=  &mbedi2c ;
I2CInterface* i2cdev= mbedi2cp;
const float Vdd = 4.97;


Serial pc(USBTX, USBRX);


//Pins for 4x4 Module

DigitalOut m4x4TTL1(p21);
DigitalOut m4x4TTL2(p22);
DigitalOut m4x4TTL3(p23);
DigitalOut m4x4TTL4(p24);
DigitalOut m4x4TTL5(p25);

DigitalOut m4x4CLK(p26); //CLk for triggering after new input


//Pins for 4x5 Module

DigitalOut m4x5TTL1(p7);
DigitalOut m4x5TTL2(p8);
DigitalOut m4x5TTL3(p9);
DigitalOut m4x5TTL4(p10);
DigitalOut m4x5TTL5(p11);

//Shutter Pins
DigitalOut SH1_1(p12);
DigitalOut SH1_2(p13);
DigitalOut SH2_1(p14);
DigitalOut SH2_2(p15);
DigitalOut SH3_1(p16);
DigitalOut SH3_2(p17);
DigitalOut SH4_1(p18);
DigitalOut SH4_2(p19);

DigitalOut m4x5CLK(p20);

DigitalOut mRefShutters(p5);

bool Shut1 = 0;
bool Shut2 = 0;
bool Shut3 = 0;
bool Shut4 = 0;




int DACSetChannel( int chan, MCP4728* dac)
{
    int ret = 0;
    char z;
    int voltCount = 0;
    string instr;

    //printf("\n\rEnter Voltage \n\r");
    while (ret == 0)
    {
        
        z = pc.getc();
        
        
        if( z == 13 )
            {
                voltCount = atoi( instr.c_str() );
                
                if(  voltCount > 4095  || voltCount < 0)
                {
                    //////pc.printf("\n\r Voltage Entered Higher than Vdd Setting Voltage to Maximum\n\r");
                    dac->setDACvalue(4095,chan);
                }
                else
                {
                        if ( dac->setDACvalue(voltCount,chan) )
                        { 
                            //printf("failed to set dac value %f for channel %d\n\r",voltCount,chan);
                        }
                        ////////pc.printf("Voltage set to %3fV\n\r", voltage);
                        if( dac->update() )
                        {
                            //printf("\n\rfailed to readback channel info \n\r");
                        }
                        else 
                        {
                                (void)dac->getDACvalue(voltCount,chan);//no need to test done with updat 
                                //printf(" CH%d %d Counts",chan,voltCount);
                                //printf("\n\r");
                    
                        }
                            
                }
                
                instr.clear();
                ret = 1;
            }
        else
            {
                ////pc.printf("%c",z);
                instr.push_back(z);
            }
    }
    return 1;
}
    





int main(void) {
  
   // get the version of getVersion 
   getVersion gv;
   int addr;

  addr = 0;
   MCP4728  dac( i2cdev ,addr, Vdd);  // assuming the address  of the MCP4728 is set to 0 factory default 
   //printf("\n\raddr %d MCP4728 :%s\n\r",addr,dac.getversioninfo());
   wait(1);

   int cnt=0;

   mRefShutters = 1;



//pc.printf("Agiltron Serial Control Program\n\r");
//pc.printf("'[' 4x4 Swtiching \n\r");
//pc.printf("']' 4x5 Swtiching\n\r");
//pc.printf("1, 2, 3, 4 Toggle Single Shutters\n\r");
//pc.printf("'o' Opens all Shutters\n\r");
//pc.printf("'r' Closes all Shutters \n\r");
//pc.printf("',' 4 Channel DAC Control \n\r");
//pc.printf("'.' Single Channel DAC Control \n\r");

//Set up dac for external voltage
dac.setRefExtern();
dac.update();

//Intialize shutters
    Shutter SH;
    SH.init( &SH1_1, &SH1_2, &SH2_1, &SH2_2, &SH3_1, &SH3_2, &SH4_1, &SH4_2 );

    SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
    
    
    //TTL pin arrays
    DigitalOut* Arr_4x4[5] = {&m4x4TTL1, &m4x4TTL2, &m4x4TTL3, &m4x4TTL4, &m4x4TTL5 };
    DigitalOut* Arr_4x5[5] = {&m4x5TTL1, &m4x5TTL2, &m4x5TTL3, &m4x5TTL4, &m4x5TTL5 };
    
    
    //Set straight pipes initial state
    m4x5TTL1 = 1;
    
    m4x4TTL1 = 1;
    float voltage = 0;
    int voltCount = 0;
    string instr;

while(1) 
{
         char c = pc.getc();
        
        if( c == '1') //Toggle Shutter 1
        {
            Shut1 = !Shut1;
            SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
            if(Shut1)
            {
                ////pc.printf("Shutter 1 Closed\n\r");
            }
            else
            {
                ////pc.printf("Shutter 1 Opened\n\r");
            }
        }
        
        else if( c == '2') //Toggle Shutter 2
        {
            Shut2 = !Shut2;
            SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
            if(Shut2)
            {
                ////pc.printf("Shutter 2 Closed\n\r");
            }
            else
            {
                ////pc.printf("Shutter 2 Opened\n\r");
            }
        }
        
        else if( c == '3') //Toggle Shutter 3
        {
            Shut3 = !Shut3;
            SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
            if(Shut3)
            {
                ////pc.printf("Shutter 3 Closed\n\r");
            }
            else
            {
                ////pc.printf("Shutter 3 Opened\n\r");
            }
        }
        
        else if( c == '4') //Toggle Shutter 4
        {
            Shut4 = !Shut4;
            SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
            if(Shut4)
            {
                ////pc.printf("Shutter 4 Closed\n\r");
            }
            else
            {
                ////pc.printf("Shutter 4 Opened\n\r");
            }
        }
        
        else if( c == 'u')
        {
            mRefShutters = 0;
            ////pc.printf("Referenced Shutters Opened\n\r");
        }
        
        else if( c == 'y')
        {
            mRefShutters = 1;
            ////pc.printf("Reference Shutters Closed\n\r");
        }
        
        else if(c == 'o')  //Open All Shutters
        {
            Shut1 = 1;
            Shut2 = 1;
            Shut3 = 1;
            Shut4 = 1;
            SH.writeShutters(1,1,1,1);
            ////pc.printf("All Shutters Opened\n\r");
        }
        
        else if(c == 'r')  //Close All Shutters
        {
            Shut1 = 0;
            Shut2 = 0;
            Shut3 = 0;
            Shut4 = 0;
            SH.writeShutters(0,0,0,0);
            ////pc.printf("All Shutters Closed\n\r");
        }
        
        else if( c == 91 ) //Left square bracket [ 4x4 Control
        {
            //Get 5 1's or 0's for binary number
            int count = 0;
            ////pc.printf("4x4 Control: Enter 5 digit binary number\n\r");
            while ( count < 5 )
            {
                c = pc.getc();
                
                if( c == '1' || c=='0' )
                {
                    *Arr_4x4[count] = atoi(&c);
                    count++;
                }
            }
            
            for( int k = 0; k<5; k++) //Trigger clocking to change values
            {
                m4x4CLK = 1;
                wait(0.1); 
                m4x4CLK = 0;
            }
            
            pc.printf("Optical Path set to : %d%d%d%d%d\n\r", m4x4TTL1.read(), m4x4TTL2.read(), m4x4TTL3.read(), m4x4TTL4.read(), m4x4TTL5.read() ); //Confirm the correct output is set
        }
        
        
        
        else if( c == 93 ) //Right square bracket ] 4x5 Control
        {
            //Get 5 1's or 0's for binary number
            int count = 0;
            ////pc.printf("4x5 Control: Enter 5 digit binary number\n\r");
            while ( count < 5 )
            {
                c = pc.getc();
                
                if( c == '1' || c=='0' )
                {
                    *Arr_4x5[count] = atoi(&c);
                    count++;
                }
            }
            
            for( int k = 0; k<5; k++) //Trigger clocking to change values
            {
                m4x5CLK = 1;
                wait(0.1); 
                m4x5CLK = 0;
            }
            
            pc.printf("Optical Path set to : %d%d%d%d%d\n\r", m4x5TTL1.read(), m4x5TTL2.read(), m4x5TTL3.read(), m4x5TTL4.read(), m4x5TTL5.read() ); //Confirm the correct output is set
        }
        
        
        else if( c == 'd')
        {
            int CH1cnt;
            int CH2cnt;
            int CH3cnt;
            int CH4cnt;
            //Print State of DAC
            if( dac.update() == 0)
            {
                (void)dac.getDACvalue(CH1cnt,0);
                (void)dac.getDACvalue(CH2cnt,1);
                (void)dac.getDACvalue(CH3cnt,2);
                (void)dac.getDACvalue(CH4cnt,3);
                pc.printf("CH1:%4d CH2:%4d CH3:%4d CH4:%4d\n\r",CH1cnt,CH2cnt,CH3cnt,CH4cnt);
            }
            
            else
            {
                pc.printf("Error: No readback from DAC\n\r");
            }
        }
        
        else if( c == 'a')
        {
            //Print State of Shutters
            pc.printf("SH1:%d SH2:%d SH3:%d SH4:%d SHRef:%d\n\r",Shut1,Shut2,Shut3,Shut4,mRefShutters.read());
        }    
        
        else if( c == ',' ) //4 Channel DAC Control
        {
            ////pc.printf("4 Channel DAC Control Enter voltage and Press Enter\n\r");
            int ret = 0;
            int chan = 0;
            while( ret ==0 && chan < 4)
            {
                char z = pc.getc();
                if( z == 13 )
                {
                    voltCount = atoi( instr.c_str() );
                    
                    if( voltCount < 0 || voltCount > 4095 )
                    {
                        //////pc.printf("ERROR\n\r");
                    }
                    else
                    {
                            if ( dac.setDACvalue(voltCount,chan) )
                            { 
                                //printf("failed to set dac value %d for channel %d\n\r",voltCount,chan);
                            }
                            //////////pc.printf("Voltage set to %3fV\n\r", voltage);
                            chan++;
                            /*
                            if( dac.update() )
                            {
                                printf("\n\rfailed to readback channel info \n\r");
                            }
                            else 
                            {
                                    (void)dac.getVoltage(voltage,chan);//no need to test done with updat 
                                    printf(" CH%d %f[V]",chan,voltage);
                                    printf("\n\r");
                                    chan++;
                            }
                            */
                                
                    }
                    if( chan == 4)
                            {
                                ret = 1;
                                wait_ms(100);
                            } 
                    instr.clear();
    
                }
                
                else if( z == ']')//Sets all channels to full voltage
                {
                    for ( int cc =0 ; cc <4 ; cc++) 
                    { 
                        if ( dac.setDACvalue(3333,cc) )
                        {
                            //printf("failed to set dac value %d for channel %d\n\r",cnt,cc);
                        }
                    }
                        //printf("All Channels Set to 5V \n\r");
                        ret = 1;
                }
                
                
                else if( z == '[')//Sets all channels to 0 voltage
                {
                    for ( int cc =0 ; cc <4 ; cc++) 
                    { 
                        if ( dac.setDACvalue(1000,cc) )
                        {
                           // printf("failed to set dac value %d for channel %d\n\r",cnt,cc);
                        }
                    }
                        //printf("All Channels Set to 0V \n\r");
                        ret = 1;
                }
                
                else
                {
                    //////pc.printf("%c",z);
                    instr.push_back(z);
                }
    }
}


        else if( c == '.' ) //Single Channel DAC Control
        {
            ////pc.printf("Single Channel DAC Control Press Channel Number\n\r");
            char z = pc.getc();
    
            if( z == '1' || z== '2' || z == '3' || z == '0' )
            {
                //////////pc.printf("Channel %c Selected",z);
                DACSetChannel( atoi(&z) , &dac);
            }   
            else
            {
                ////pc.printf("ERROR");
            }
        }

}
    //Never Reach This
    return 1;
}
    