/*
Known issues with mbed program for future reference
1.
2.
3.

*/


/** example program for the use of the MCP4728 class and DACInterface.h classes
 *
 *  V 1.0  : tested on the KL05z  but without the MCP4728 connected \
 * (C) Wim Beaumont Universiteit Antwerpen 2016
 */

#define MCP4728EXAMPLEVER "2.04"
#define TARGET_MBED 1

#include "mbed.h"
#include <string>
#include <cstring>

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#elif defined (TARGET_MBED)
PinName const SDA = p28;
PinName const SCL = p27;
#else
#error TARGET NOT DEFINED
#endif


#include "I2C.h"
#include "I2CInterface.h"
#include "MBEDI2CInterface.h"
#include "DACInterface.h"
#include "dev_interface_def.h"
#include "MCP4728setaddr.h"
#include "mcp4728.h"
#include "shutter.h"

MBEDI2CInterface mbedi2c( SDA, SCL);
MBEDI2CInterface* mbedi2cp=  &mbedi2c ;
I2CInterface* i2cdev= mbedi2cp;
const float Vdd = 4.97;


Serial pc(USBTX, USBRX);


DigitalOut CameraTrig(p29);
InterruptIn TrigInt(p30);
InterruptIn TrigHW(p30);
int TrigMode = 0;


//Pins for 4x4 Module
DigitalOut m4x4TTL1(p21);
DigitalOut m4x4TTL2(p22);
DigitalOut m4x4TTL3(p23);
DigitalOut m4x4TTL4(p24);
DigitalOut m4x4TTL5(p25);

DigitalOut m4x4CLK(p26); //CLk for triggering after new input



//Pins for 4x5 Module

DigitalOut m4x5TTL1(p7);
DigitalOut m4x5TTL2(p8);
DigitalOut m4x5TTL3(p9);
DigitalOut m4x5TTL4(p10);
DigitalOut m4x5TTL5(p11);

//Shutter Pins
DigitalOut SH1_1(p12);
DigitalOut SH1_2(p13);
DigitalOut SH2_1(p14);
DigitalOut SH2_2(p15);
DigitalOut SH3_1(p16);
DigitalOut SH3_2(p17);
DigitalOut SH4_1(p18);
DigitalOut SH4_2(p19);

DigitalOut m4x5CLK(p20);

DigitalOut mRefShutters(p5);

bool Shut1 = 0;
bool Shut2 = 0;
bool Shut3 = 0;
bool Shut4 = 0;


int DVOA1 = 0;
int DVOA2 = 0;
int DVOA3 = 0;
int DVOA4 = 0;

bool trigSet = 0;

string pcstr;
string seqstr;
Timer t;

MCP4728* gbldac;
Shutter* gblSH;



void trigSH( Shutter SH, int nimg )
{
    for(int i = 0; i<nimg; i++) {
        SH.writeShutters(1,1,1,1);//Turn on Shutters

        wait_us(92);//Wait for shutter to go high
        wait_us(120);//Wait to trigger until middle of Shutter Opening

        CameraTrig = 1;//Trigger Camera to turn on
        wait_us(38);//Wait for rest of 250 us

        //wait_us(16417); //DEBUG: Added extra delay to slow down trigger

        //Turn off shutters and Camera Trigger
        SH.writeShutters(0,0,0,0);

        CameraTrig = 0;

        wait_us(8183); //Wait to run at 120 Hz

        //wait_us(16417); //DEBUG: Added extra delay to slow down trigger
    }
    //pc.printf("Triggered Shutters (trigSH) \n\r");
}


void trigNotEyeSafe( Shutter SH, int nimg )
{
    for(int i = 0; i<nimg; i++) {
        //SH.writeShutters(1,1,1,1);//Turn on Shutters

        wait_us(92);//Wait for shutter to go high
        wait_us(120);//Wait to trigger until middle of Shutter Opening

        CameraTrig = 1;//Trigger Camera to turn on
        wait_us(38);//Wait for rest of 250 us

        //wait_us(16417);//DEBUG: Added extra delay to slow down trigger

        //Turn off shutters and Camera Trigger
        //SH.writeShutters(0,0,0,0);
        CameraTrig = 0;

        wait_us(8183); //Wait to run at 120 Hz

        // wait_us(16417);//DEBUG: Added extra delay to slow down trigger
    }
    //pc.printf("Triggered Shutters (trigNotEyeSafe) \n\r");
}



int DACSetChannel( int chan, MCP4728* dac, int counts)
{
    int ret = 0;
    int z = 0;
    int CHcnt;
    int voltCount = counts;
    string instr;

    if(  voltCount > 4095  || voltCount < 0) {
        voltCount = 4095;
    }

    while(ret == 0 && z < 10) {
        //t.start();
        dac->update();
        //t.stop();
        //t.reset();
        //pc.printf("DAC update took %f seconds \n\r",t.read());
        (void)dac->getDACvalue(CHcnt,chan);

        if(CHcnt == counts) {
            ret = 1;
        } else {
            //t.start();
            dac->setDACvalue(voltCount,chan);
            //t.stop();
            //pc.printf("DAC setting took %f seconds \n\r",t.read());
            z++;
        }


    }


    return 1;
}

void set4x4Piping(DigitalOut** Arr_4x4, char z1, char z2, char z3, char z4, char z5)
{


    *Arr_4x4[0] = atoi(&z1);
    *Arr_4x4[1] = atoi(&z2);
    *Arr_4x4[2] = atoi(&z3);
    *Arr_4x4[3] = atoi(&z4);
    *Arr_4x4[4] = atoi(&z5);

    for( int k = 0; k<2; k++) { //Trigger clocking to change values
        m4x4CLK = 1;
        wait_us(200);
        m4x4CLK = 0;
    }

    //pc.printf("Optical Path set to : %d%d%d%d%d\n\r", m4x4TTL1.read(), m4x4TTL2.read(), m4x4TTL3.read(), m4x4TTL4.read(), m4x4TTL5.read() ); //Confirm the correct output is set
}

void set4x5Piping(DigitalOut** Arr_4x5, char z1, char z2, char z3, char z4, char z5)
{


    *Arr_4x5[0] = atoi(&z1);
    *Arr_4x5[1] = atoi(&z2);
    *Arr_4x5[2] = atoi(&z3);
    *Arr_4x5[3] = atoi(&z4);
    *Arr_4x5[4] = atoi(&z5);

    for( int k = 0; k<2; k++) { //Trigger clocking to change values
        m4x5CLK = 1;
        wait_us(200);
        m4x5CLK = 0;
    }

    //pc.printf("Optical Path set to : %d%d%d%d%d\n\r", m4x5TTL1.read(), m4x5TTL2.read(), m4x5TTL3.read(), m4x5TTL4.read(), m4x5TTL5.read() ); //Confirm the correct output is set
}



void toggleShut1(Shutter SH)
{
    Shut1 = !Shut1;
    SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
}


void toggleShut2(Shutter SH)
{
    Shut2 = !Shut2;
    SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
}


void toggleShut3(Shutter SH)
{
    Shut3 = !Shut3;
    SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
}


void toggleShut4(Shutter SH)
{
    Shut4 = !Shut4;
    SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
}

void closeRef()
{
    mRefShutters = 0;
}

void openRef()
{
    mRefShutters = 1;
}

void openAllHP(Shutter SH)
{
    Shut1 = 1;
    Shut2 = 1;
    Shut3 = 1;
    Shut4 = 1;
    SH.writeShutters(1,1,1,1);
}

void closeAllHP(Shutter SH)
{
    Shut1 = 0;
    Shut2 = 0;
    Shut3 = 0;
    Shut4 = 0;
    SH.writeShutters(0,0,0,0);
}

void setAllShutters(Shutter SH,char z1, char z2, char z3, char z4)
{

    Shut1 = atoi(&z1);
    Shut2 = atoi(&z2);
    Shut3 = atoi(&z3);
    Shut4 = atoi(&z4);
    SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
}

void queryDAC(MCP4728* dac)
{
    int CH1cnt;
    int CH2cnt;
    int CH3cnt;
    int CH4cnt;
    //Print State of DAC
    if( dac->update() == 0) {
        (void)dac->getDACvalue(CH1cnt,0);
        (void)dac->getDACvalue(CH2cnt,1);
        (void)dac->getDACvalue(CH3cnt,2);
        (void)dac->getDACvalue(CH4cnt,3);
        pc.printf("CH1:%4d CH2:%4d CH3:%4d CH4:%4d\n\r",CH1cnt,CH2cnt,CH3cnt,CH4cnt);
    }

    else {
        pc.printf("Error: No readback from DAC\n\r");
    }
}

void queryShutters()
{
    //Print State of Shutters
    pc.printf("SH1:%d SH2:%d SH3:%d SH4:%d SHRef:%d\n\r",Shut1,Shut2,Shut3,Shut4,mRefShutters.read());
}

void HWTrigHandler()
{
    //pc.printf("Hardware Interrupt Triggered \n\r");
    
    if (TrigMode == 0)
    {
        trigSet = 1;
    }
    
    else
   { 
    int i;
    int nimgs = 0;
    //pc.printf("Interrupt Triggered \n\r");
    for(i = 0; i<seqstr.size(); i++) {
        //Find characters and then grab next three digits as the number of times to trigger

        if( seqstr[i] == 'i') {
            nimgs = atoi( seqstr.substr(i+1, i+3).c_str() );
            DACSetChannel( 0, gbldac, 4095);
            DACSetChannel( 1, gbldac, 4095);
            DACSetChannel( 2, gbldac, 4095);
            DACSetChannel( 3, gbldac, 4095);
            trigSH( *gblSH, nimgs );
            //pc.printf("Num Illums: %d\n",nimgs);
        } else if( seqstr[i] == 'd') {
            nimgs = atoi( seqstr.substr(i+1, i+3).c_str() );
            gblSH->writeShutters(0,0,0,0);
            DACSetChannel( 0, gbldac, 4095);
            DACSetChannel( 1, gbldac, 4095);
            DACSetChannel( 2, gbldac, 4095);
            DACSetChannel( 3, gbldac, 4095);
            trigNotEyeSafe( *gblSH, nimgs );
            //pc.printf("Num Darks: %d\n",nimgs);
        } else if( seqstr[i] == 'c') {
            nimgs = atoi( seqstr.substr(i+1, i+3).c_str() );
            DACSetChannel( 0, gbldac, DVOA1);
            DACSetChannel( 1, gbldac, DVOA2);
            DACSetChannel( 2, gbldac, DVOA3);
            DACSetChannel( 3, gbldac, DVOA4);
            trigSH( *gblSH, nimgs );

            //pc.printf("Num Contours: %d\n",nimgs);
        }



        else if( seqstr[i] == 'r') {
            nimgs = atoi( seqstr.substr(i+1, i+3).c_str() );
            DACSetChannel( 0, gbldac, DVOA1);
            DACSetChannel( 1, gbldac, DVOA2);
            DACSetChannel( 2, gbldac, DVOA3);
            DACSetChannel( 3, gbldac, DVOA4);
            gblSH->writeShutters(0,0,0,0);
            trigNotEyeSafe( *gblSH, nimgs );
            //pc.printf("Num Refs: %d\n",nimgs);
        }

    }
    }
}

void extTrigHandler()
{
    //In this mode trigger button sets the query Trig to high
    //Matlab query the trigger to see if it needs to stop
    
    //trigSet = 1;
    
    
    /*
    
    */
}


int main(void)
{

    //get the version of getVersion
    getVersion gv;
    int addr;
    //Timer m;
    addr = 0;
    MCP4728  dac( i2cdev ,addr, Vdd);  // assuming the address  of the MCP4728 is set to 0 factory default
    gbldac = &dac;
    wait(1);

    pc.baud(921600);
    mRefShutters = 1;

    //Set up dac for external voltage
    dac.setRefExtern();
    dac.update();

    //Intialize shutters
    Shutter SH;
    SH.init( &SH1_1, &SH1_2, &SH2_1, &SH2_2, &SH3_1, &SH3_2, &SH4_1, &SH4_2 );

    SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
    gblSH = &SH;

    //Set up ext trig interrupt
    TrigInt.rise(&extTrigHandler);
    TrigInt.mode(PullUp);
    
    TrigHW.rise(&HWTrigHandler);
    TrigHW.mode(PullUp);
    TrigHW.enable_irq();  
  

    //TTL pin arrays
    DigitalOut* Arr_4x4[5] = {&m4x4TTL1, &m4x4TTL2, &m4x4TTL3, &m4x4TTL4, &m4x4TTL5 };
    DigitalOut* Arr_4x5[5] = {&m4x5TTL1, &m4x5TTL2, &m4x5TTL3, &m4x5TTL4, &m4x5TTL5 };


    //Set straight pipes initial state
    m4x5TTL1 = 1;
    m4x4TTL1 = 1;

    string instr;

    seqstr  = "d010r010i010c010";

    pcstr.resize(200);

    while(1)
    {
        //pc.printf("looping");
        pc.scanf("%s", pcstr.c_str() );


        int indexArr[100];
        int indexSize = 0;


        //had to change as string does not resize
        int i =0;
        while( pcstr.c_str()[i] != 0 && pcstr.c_str()[i] != ' ' && pcstr.c_str()[i] != '\0')
        {
            if( pcstr[i] == ',')
            {
                indexArr[indexSize] = i;
                indexSize++;
            }
            i++;
        }

        //DEBUG
        //pc.printf( "Commas Found %d\n\r",indexSize );



    //Interpret commands
    for(int i =0; i<indexSize; i++)
    {
        //DEBUG
        //pc.printf( "Loop #%d of %d\n\r",i,indexSize-1 );

        char c;
        //command must begin with a comma
        c = pcstr.c_str()[ indexArr[i] +1 ];

        //DEBUG
        //pc.printf( "Cmd is %c\n\r",c );


        if( c == '1') //Toggle Shutter 1
        {
            char z1 = pcstr[ indexArr[i] +2 ];
            Shut1 = atoi(&z1);
            SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
        }

        else if( c == '2') //Toggle Shutter 2
        {
            char z1 = pcstr[ indexArr[i] +2 ];
            Shut2 = atoi(&z1);
            SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
        }

        else if( c == '3') //Toggle Shutter 3
        {
            char z1 = pcstr[ indexArr[i] +2 ];
            Shut3 = atoi(&z1);
            SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
        }

        else if( c == '4') //Toggle Shutter 4
        {
            char z1 = pcstr[ indexArr[i] +2 ];
            Shut4 = atoi(&z1);
            SH.writeShutters(Shut1,Shut2,Shut3,Shut4);
        }
        
        else if (c == '5')
        {
            TrigMode = 0; 
        }
        
        else if (c == '6')
        {
            TrigMode = 1;
        }

        else if( c == 'u')
        {
            closeRef();
        }

        else if( c == 'y')
        {
            openRef();
        }

        else if(c == 'o')  //Open All Shutters
        {
            openAllHP(SH);
        }

        else if(c == 'r')  //Close All Shutters
        {
            closeAllHP(SH);
        }

        else if( c == 'm')
        {
            //string sub = pcstr.substr( indexArr[i]+2 , 4 );//Used for DAC
            char z1 = pcstr[ indexArr[i] +2 ];
            char z2 = pcstr[ indexArr[i] +3 ];
            char z3 = pcstr[ indexArr[i] +4 ];
            char z4 = pcstr[ indexArr[i] +5 ];
            setAllShutters(SH,z1,z2,z3,z4);
        }

        else if( c == 91 ) //Left square bracket [ 4x4 Control
        {
            //get inputs for 4x4
            char z1 = pcstr[ indexArr[i] +2 ];
            char z2 = pcstr[ indexArr[i] +3 ];
            char z3 = pcstr[ indexArr[i] +4 ];
            char z4 = pcstr[ indexArr[i] +5 ];
            char z5 = pcstr[ indexArr[i] +6 ];
            set4x4Piping(Arr_4x4,z1,z2,z3,z4,z5);
        }


        else if( c == 93 ) //Right square bracket ] 4x5 Control
        {
            char z1 = pcstr[ indexArr[i] +2 ];
            char z2 = pcstr[ indexArr[i] +3 ];
            char z3 = pcstr[ indexArr[i] +4 ];
            char z4 = pcstr[ indexArr[i] +5 ];
            char z5 = pcstr[ indexArr[i] +6 ];
            set4x5Piping(Arr_4x5,z1,z2,z3,z4,z5);
        }


        else if( c == 'd')
        {
            queryDAC(&dac);
        }

        else if( c == 'a')
        {
            queryShutters();
        }
        

        
        else if( c == '.' ) //Single Channel DAC Control
        {
            ////pc.printf("Single Channel DAC Control Press Channel Number\n\r");


            char achan =  pcstr[ indexArr[i] + 2 ];
            int ichan = atoi(&achan);

            char acount[5];
            acount[0] = pcstr[ indexArr[i] + 3 ];
            acount[1] = pcstr[ indexArr[i] + 4 ];
            acount[2] = pcstr[ indexArr[i] + 5 ];
            acount[3] = pcstr[ indexArr[i] + 6 ];
            acount[4] = '\0';
            int icount = atoi(acount);//Get 4 digit Count
            //icount = icount / 10;
            //DEBUG
            //pc.printf("DAC Channel: %d    DAC Counts: %d   Acount:\n\r",ichan,icount);


            if( achan == '1' || achan== '2' || achan == '3' || achan == '0' )
            {
                //////////pc.printf("Channel %c Selected",z);
                DACSetChannel( ichan , &dac, icount);
            }
            else
            {
                ////pc.printf("ERROR");
            }
        }

        else if( c == '<' )
        {
            //pc.printf("Interrupts Disabled \n\r");
            TrigInt.disable_irq();
        }

        else if( c == '>' )
        {
            //pc.printf("Interrupts Enabled \n\r");
            TrigInt.enable_irq();

        }
        
        else if( c == 'q')
        {
            //Query trigger
            if( trigSet == 1)
            {
                trigSet = 0;
                pc.printf("Yy\n\r");
            }
            else
            {
                trigSet = 0;
                pc.printf("Nn\n\r");
            }
        }
        

        else if( c == 't')
        {

            extTrigHandler();

        }


        else if( c == 'S')
        {
            DVOA1 = atoi( pcstr.substr( indexArr[i] +2, indexArr[i] + 5).c_str() );
            DVOA2 = atoi( pcstr.substr( indexArr[i] +6, indexArr[i] + 9).c_str() );
            DVOA3 = atoi( pcstr.substr( indexArr[i] +10, indexArr[i] + 13).c_str() );
            DVOA4 = atoi( pcstr.substr( indexArr[i] +14, indexArr[i] + 17).c_str() );

        }



        else if( c == 's' )
        {
            seqstr = pcstr.substr( indexArr[i] +2, indexArr[i+1] -1 );
            //pc.printf("String is %s \n",seqstr.c_str());
        }


        else if( c == ';')
        {
            //Dumb states of everything out
            //All on one line

            //Shutters
            pc.printf("SH1:%d SH2:%d SH3:%d SH4:%d SHRef:%d",Shut1,Shut2,Shut3,Shut4,mRefShutters.read());

            //DAC
            int CH1cnt;
            int CH2cnt;
            int CH3cnt;
            int CH4cnt;

            //Print State of DAC
            int sts = dac.update();
            int updatecnt = 0;


            while( sts != 0 && updatecnt < 5)
            {
                if(sts != 0)
                {
                    sts = dac.update();
                    updatecnt++;

                }
            }

            if( updatecnt >= 5)
            {
                pc.printf("CH1:xxxx CH2:xxxx CH3:xxxx CH4:xxxx");
            }
            else
            {
                (void)dac.getDACvalue(CH1cnt,0);
                (void)dac.getDACvalue(CH2cnt,1);
                (void)dac.getDACvalue(CH3cnt,2);
                (void)dac.getDACvalue(CH4cnt,3);
                pc.printf("CH1:%4d CH2:%4d CH3:%4d CH4:%4d",CH1cnt,CH2cnt,CH3cnt,CH4cnt);
            }

            //Piping
            pc.printf("4x4:%d%d%d%d%d", m4x4TTL1.read(), m4x4TTL2.read(), m4x4TTL3.read(), m4x4TTL4.read(), m4x4TTL5.read() );
            pc.printf("4x5:%d%d%d%d%d\n", m4x5TTL1.read(), m4x5TTL2.read(), m4x5TTL3.read(), m4x5TTL4.read(), m4x5TTL5.read() );
        }

        else if( c == '+' )
        {
            pc.printf(",[%d%d%d%d%d,]%d%d%d%d%d", m4x4TTL1.read(), m4x4TTL2.read(), m4x4TTL3.read(), m4x4TTL4.read(), m4x4TTL5.read(), m4x5TTL1.read(), m4x5TTL2.read(), m4x5TTL3.read(), m4x5TTL4.read(), m4x5TTL5.read() );
            pc.printf(",m%d%d%d%d",Shut1,Shut2,Shut3,Shut4);
            int CH1cnt;
            int CH2cnt;
            int CH3cnt;
            int CH4cnt;

            int sts = dac.update();
            int updatecnt = 0;


            while( sts != 0 && updatecnt < 5)
            {

                if(sts != 0)
                {
                    sts = dac.update();
                    updatecnt++;

                }

            }
            if( updatecnt >= 5 && sts != 0)
            {
                pc.printf(",.0xxxx,.1xxxx,.2xxxx,.3xxxx\n");
            }
            else
            {
                (void)dac.getDACvalue(CH1cnt,0);
                (void)dac.getDACvalue(CH2cnt,1);
                (void)dac.getDACvalue(CH3cnt,2);
                (void)dac.getDACvalue(CH4cnt,3);
                pc.printf(",.0%04d,.1%04d,.2%04d,.3%04d\n",CH1cnt,CH2cnt,CH3cnt,CH4cnt);
            }

        }

    }

    }
    //Never Reach This
    return 1;
    }
