#include "mbed.h"
#include "C12832.h"
#include "USBMouse.h"



USBMouse mouse;
//BusIn joy(p15,p12,p13,p16);
BusIn Up(p15);
BusIn Down(p12);
BusIn Left(p13);
BusIn Right(p16);
DigitalIn fire(p14);

DigitalOut r (p25);
DigitalOut step(p24);

AnalogIn pot1(p19);
AnalogIn pot2(p20);

C12832 lcd(p5, p7, p6, p8, p11);



int main()
{
    int max_speed = 10000;
    int p1, p2;
    int speed;
    int dir;
    lcd.set_auto_up(0);
    
    
    while(true) {
        p1 = pot1.read_u16();
        p2 = pot2.read_u16();
        
        speed = p1 * max_speed / 0xffff;
        
        lcd.locate(0, 0);
        lcd.printf("Speed : %3d", speed);
        p1 = p1 * lcd.width() / 0xffff;
        lcd.fillrect(0, 9, p1, 14, 1);
        lcd.fillrect(p1 + 1, 9, lcd.width() - 1, 14, 0);
        lcd.locate(0, 16);
        
        dir = p2 * 100 / 0xffff;
        lcd.printf("Dir: %3d ", dir);
        p2 = p2 * lcd.width() / 0xffff;
        lcd.fillrect(0, 25, p2, 30, 1);
        lcd.fillrect(p2 + 1, 25, lcd.width(), 30, 0);
        
        lcd.copy_to_lcd();
        
        if( dir > 50 ) 
        {
            r = 1;    
        }        
        else
        {
            r = 0;
        }
        
        
        if(fire)
        {
            while(fire)
            {
                step = 1;
                wait( 1.0/ speed);
                step = 0;
            }
        }
        
        if(Left)
        {
            while(Left)
            {
            }
            for(int i=0; i< 200; i++)
            {
                step = 1;
                wait(1.0/speed);
                step = 0;
            }
         }
         
    
         wait(0.001);   
        //wait(0.1);
    }
}
