#include "mbed.h"
#include <string>

Serial pc(USBTX, USBRX); // tx, rx
Serial device(p9,p10);
string pcstr;



int main() 
{
    device.baud(38400);//Default for blue LDM
    pc.baud(9600);
    pc.printf("Mbed Test of CP4 LDM \n\r");
    
    while(1) 
    {
        
        //Echo LDM output to PC
        if(device.readable())
        {
            pc.putc(device.getc());
        }
        
        //Read from PC termial and write commands to LDM 
        if(pc.readable())
        {
            pc.scanf("%s", pcstr.c_str() );
            char c = pcstr.c_str()[0];
            pc.printf("Mbed Command Received: %c\n\r",c);
            //List of LDM Commands
   
            //Take Single Measurement
            if( c == '[' )
            {
                pc.printf("iSM\n\r");
                device.printf("iSM\n\r");
            }
            if (c == 'm')
            {
                pc.printf("iSET:5,1\n\r");
                device.printf("iSET:5,1\n\r");
            }
            if (c == 'n')
            {
                pc.printf("iSET:5,0\n\r");
                device.printf("iSET:5,0\n\r");
            }
            //Continuous Measurement
            if( c == 'c' )
            {
                pc.printf("iACM\n\r");
                device.printf("iACM\n\r");
            }
            //Fast Continuous Measurement
            if( c == 'C' )
            {
                pc.printf("iFACM\n\r");
                device.printf("iFACM\n\r");
            }
            //Stop Measurement
            if ( c == 's' )
            {
                pc.printf("iHALT\n\r");
                device.printf("iHALT\n\r");
            }
            //Laser Pointer On
            if( c == ',' )
            {
                pc.printf("iLD:1\n\r");
                device.printf("iLD:1\n\r");
            }
            //Laser Pointer Off
            if( c == '.' )
            {
                pc.printf("iLD:0\n\r");
                device.printf("iLD:0\n\r");
            }
        }
        

        

    }
}