

#include "mbed.h"
#include    "IAP.h"
#include "TextLCD.h"
#include "stdlib.h"
#include <stdio.h>

#define     FLOAT_SIZE        4
#define     TARGET_ADDRESS   64
#define     NEXT_PLACE 1
#define     PLACE   0

IAP     iap;
float getEepromFloat(int place);
void teletype(char* text, int row);

typedef char * string;

// ====== Pins =========

DigitalOut gLED(P1_18);
DigitalOut rLED(P1_24);


TextLCD lcd(P1_22, P1_14, P0_9, P0_8, P1_21, P1_2); // rs, e, d4-d7


//Tie unused analogue pins LOW

DigitalOut a1(P0_15);
DigitalOut a2(P0_16);
DigitalOut a3(P0_22);
DigitalOut a4(P0_23);

// ====== Variables =========

float test_float = 12.5;
float display_float = 0.0;

int twodp =0;

float _ON;
float _OFF;

float calib;
float voltage;
float displayVoltage;
float displaySet;

float difference = 0;
float calibrate=0.0;




// ====== CODE BEGINS=========

typedef union _data {
    float f;
    char  s[4];
} myData;


float getEepromFloat(int place)
{
    myData returnedFloat;
    char someBytes[4];

    iap.read_eeprom( (char*)(TARGET_ADDRESS+(place*4)), someBytes, FLOAT_SIZE );

    returnedFloat.s[0] = someBytes[0];
    returnedFloat.s[1] = someBytes[1];
    returnedFloat.s[2] = someBytes[2];
    returnedFloat.s[3] = someBytes[3];
    return returnedFloat.f;

}

void setEepromFloat(int place, float incomingFloat)
{
    char theBytes[4];
    myData aFloat;

    aFloat.f = incomingFloat;

    theBytes[0] = aFloat.s[0];
    theBytes[1] = aFloat.s[1];
    theBytes[2] = aFloat.s[2];
    theBytes[3] = aFloat.s[3];

    iap.write_eeprom( theBytes, (char*) (TARGET_ADDRESS+(place*4)), FLOAT_SIZE );

}


int main()
{

    teletype("Hello", 0);
    float aValue=0.0;
    float theReturned=99.99;
    
    while (1) {
                wait(2.0);
                
                aValue++;     // increment it
                
                setEepromFloat(PLACE,aValue);         //put it in place 0 (Global variable)
                        
                theReturned = getEepromFloat(PLACE); //get it back
                
                lcd.cls();
                teletype("Value: %f", theReturned);  //output it to the screen
                

    };
}




char* left(string Source,int NewLen)
{

    char* result;
    char* temp;
    if (NewLen <=0)
        NewLen =1; /* Minimum length */

    result = (char*)malloc(NewLen + 1); /* +1 = DFTTZ! */
    *result=' ';   /* default for unassigned strings */
    temp=result;
    if (Source && *Source) { /* don't copy an empty string */
        while (NewLen-- >0)
            *temp++=*Source++;
    } else temp++;
    *temp='\0';
    return result;
}

void teletype(char* text, int row)
{
    lcd.locate(0,row);
    lcd.printf("                ");

    int whole=strlen(text);

    for (int i=1; i<=whole; i++) {
        lcd.locate(0,row);
        lcd.printf(left(text,i));
        wait(0.15);
    }
}


