#include "mbed.h"

I2C    i2c(PB_9, PB_8);
Ticker ticker1;
Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut  myled(PA_5);
DigitalIn   mybutton(PC_13);

int n = 0;
int k = 0;
char c;
char d[2];

void timer1()
{
    myled = !myled;
    if ( k > 0) {
        k = k - 1;
        myled = 0;
    }
}

void search(){
    while ( k == 0 ) {
        if ( (i2c.read( n, d, 1, false)) > 0 ) {
            n = n + 1;
        } else {
            k = 6;
        }
        if ( n > 255 ) k = 6;
    }
    if ( n < 256 ) {
        pc.printf( "address chip= %d\n", n );
    } else {
        pc.printf( "error address chip\n" );
    }
}

void decode(){
    if ( c == '0' ) {
        d[0] = 0;
        d[1] = 0;
        if ( (i2c.write( n, d, 2, false)) > 0 ) {
            pc.printf( "error write\n" );
        } else {
            pc.printf( "write byte address 0 = 0\n");
        }
    }
    if ( c == '1' ) {
        d[0] = 0;
        d[1] = 1;
        if ( (i2c.write( n, d, 2, false)) > 0 ) {
            pc.printf( "error write\n" );
        } else {
            pc.printf( "write byte address 0 = 1\n");
        }
    }
    if ( c == '2' ) {
        d[0] = 0;
        if ( (i2c.write( n, d, 1, false)) > 0 ) {
            pc.printf( "error write\n" );
        } else {
            if ( (i2c.read( n, d, 1, false)) > 0 ) {
                pc.printf( "error read\n" );
            } else {
                pc.printf( "read byte address 0 = %d\n", d[0] );
            }
        }
    }
    if ( c == '3' ) {
        d[0] = 1;
        d[1] = 0;
        if ( (i2c.write( n, d, 2, false)) > 0 ) {
            pc.printf( "error write\n" );
        } else {
            pc.printf( "write byte address 1 = 0\n");
        }
    }
    if ( c == '4' ) {
        d[0] = 1;
        d[1] = 1;
        if ( (i2c.write( n, d, 2, false)) > 0 ) {
            pc.printf( "error write\n" );
        } else {
            pc.printf( "write byte address 1 = 1\n");
        }
    }
    if ( c == '5' ) {
        d[0] = 1;
        if ( (i2c.write( n, d, 1, false)) > 0 ) {
            pc.printf( "error write\n" );
        } else {
            if ( (i2c.read( n, d, 1, false)) > 0 ) {
                pc.printf( "error read\n" );
            } else {
                pc.printf( "read byte address 1 = %d\n", d[0] );
            }
        }
    }
}

int main(){
    search();
    ticker1.attach(&timer1, 1);
    while(1) {
        if ( mybutton == 0 ) {
            if ( k == 0 ) {
                n = 0;
                search();
            }
        }
        if ( pc.readable() ) {
            c = pc.getc();
            if ( n < 256 ) decode();
        }
    }
}
