   /******************
   QT2160.h
   Created on: Feb 16, 2017
   Author: Akila Kasunjith Hettiarachchi
*/


#ifndef QT2160
#define QT2160

#define reg_chipID 0
#define reg_generalStatus 2
#define reg_keyStatus1 3
#define reg_keyStatus2 4
#define reg_sliderTouchPosition 5
#define reg_GPIORead 6
#define reg_subRevision 7
#define reg_calibrate 10
#define reg_reset 11
#define reg_LPMode 12
#define reg_burstRepetition 13
#define reg_NegDC 15
#define reg_posDC 16
#define reg_normalDILimit 17
#define reg_negRecalDelay 18
#define reg_driftHoldTime 19
#define reg_sliderControl 20
#define reg_sliderOptions 21

//key control registers

#define reg_key_0_control 22
#define reg_key_1_control 23
#define reg_key_2_control 24
#define reg_key_3_control 25
#define reg_key_4_control 26
#define reg_key_5_control 27
#define reg_key_6_control 28
#define reg_key_7_control 29
#define reg_key_8_control 30
#define reg_key_9_control 31
#define reg_key_10_control 32
#define reg_key_11_control 33
#define reg_key_12_control 34
#define reg_key_13_control 35
#define reg_key_14_control 36
#define reg_key_15_control 37

//  Negative threshold control registers

#define reg_key_0_NTHR 38
#define reg_key_1_NTHR 39
#define reg_key_2_NTHR 40
#define reg_key_3_NTHR 41
#define reg_key_4_NTHR 42
#define reg_key_5_NTHR 43
#define reg_key_6_NTHR 44
#define reg_key_7_NTHR 45
#define reg_key_8_NTHR 46
#define reg_key_9_NTHR 47
#define reg_key_10_NTHR 48
#define reg_key_11_NTHR 49
#define reg_key_12_NTHR 50
#define reg_key_13_NTHR 51
#define reg_key_14_NTHR 52
#define reg_key_15_NTHR 53

//Burst length control registers

#define reg_key_0_BL 54
#define reg_key_1_BL 55
#define reg_key_2_BL 56
#define reg_key_3_BL 57
#define reg_key_4_BL 58
#define reg_key_5_BL 59
#define reg_key_6_BL 60
#define reg_key_7_BL 61
#define reg_key_8_BL 62
#define reg_key_9_BL 63
#define reg_key_10_BL 64
#define reg_key_11_BL 65
#define reg_key_12_BL 66
#define reg_key_13_BL 67
#define reg_key_14_BL 68
#define reg_key_15_BL 69

#define reg_GPIODrive1 70
#define reg_GPIODrive2 71
#define reg_GPIODirection2 73
#define reg_GPIOPWM1 74
#define reg_GPIOPWM2 75
#define reg_PWMLevel 76
#define reg_GPIOWake 77
#define reg_commonChangeKeys1 78
#define reg_commonChangeKeys2 79

#define i2cDelay 50


struct readRegs
{
    char generalStatus;
    char keyStatus1;
    char keyStatus2;
    char sliderTouchPosition;
    char GPIORead;
};

union readRegsUnion {
    char all[5];
    struct readRegs Regs;
};

 struct QT 
{
    I2C &i2c;
    uint8_t ADDR;
    uint8_t LPmode;
    uint8_t BREP;
    uint8_t NDRIFT;
    uint8_t PDRIFT;
    uint8_t NDIL;
    uint8_t NRD;
    uint8_t DHT;
    uint8_t SliderControl;
    uint8_t RESOLUTION;
    uint8_t KEY_CONT[16];
    uint8_t NTHR[16];
    uint8_t BL[16];
    uint8_t GPIODrive1;
    uint8_t GPIODrive2;
    uint8_t GPIODirection;
    uint8_t GPIOPWM1;
    uint8_t GPIOPWM2;
    uint8_t GPIOPWMLevel;
    uint8_t GPIOWake;
    uint8_t commonChangeKeys;
    union readRegsUnion readData;
} ;

void qtWrite( QT &qt, uint8_t reg_addr, uint8_t reg_value)
{
    char write_data[5];
    write_data[0] = reg_addr;
    write_data[1] = reg_value;
    qt.i2c.write(qt.ADDR, write_data, 2);
    wait_ms(i2cDelay);
}

void QTSetup(QT &qt)
{
    qtWrite(qt, reg_reset, 8);
    qtWrite(qt, reg_calibrate, 1);
    qtWrite(qt, reg_LPMode, qt.LPmode);
    qtWrite(qt, reg_burstRepetition, qt.BREP);
    qtWrite(qt, reg_NegDC, qt.NDRIFT);
    qtWrite(qt, reg_posDC, qt.PDRIFT);
    qtWrite(qt, reg_normalDILimit, qt.NDIL);
    qtWrite(qt, reg_driftHoldTime, qt.DHT);
    qtWrite(qt, reg_sliderControl, qt.SliderControl);
    qtWrite(qt, reg_sliderOptions, qt.RESOLUTION);
    //***************key control register*************************//
    qtWrite(qt, reg_key_0_control, qt.KEY_CONT[0]);
    qtWrite(qt, reg_key_1_control, qt.KEY_CONT[1]);
    qtWrite(qt, reg_key_2_control, qt.KEY_CONT[2]);
    qtWrite(qt, reg_key_3_control, qt.KEY_CONT[3]);
    qtWrite(qt, reg_key_4_control, qt.KEY_CONT[4]);
    qtWrite(qt, reg_key_5_control, qt.KEY_CONT[5]);
    qtWrite(qt, reg_key_6_control, qt.KEY_CONT[6]);
    qtWrite(qt, reg_key_7_control, qt.KEY_CONT[7]);
    qtWrite(qt, reg_key_8_control, qt.KEY_CONT[8]);
    qtWrite(qt, reg_key_9_control, qt.KEY_CONT[9]);
    qtWrite(qt, reg_key_10_control, qt.KEY_CONT[10]);
    qtWrite(qt, reg_key_11_control, qt.KEY_CONT[11]);
    qtWrite(qt, reg_key_12_control, qt.KEY_CONT[12]);
    qtWrite(qt, reg_key_13_control, qt.KEY_CONT[13]);
    qtWrite(qt, reg_key_14_control, qt.KEY_CONT[14]);
    qtWrite(qt, reg_key_15_control, qt.KEY_CONT[15]);
    //********************NTHR registers*************************//
    qtWrite(qt, reg_key_0_NTHR, qt.NTHR[0]);
    qtWrite(qt, reg_key_1_NTHR, qt.NTHR[1]);
    qtWrite(qt, reg_key_2_NTHR, qt.NTHR[2]);
    qtWrite(qt, reg_key_3_NTHR, qt.NTHR[3]);
    qtWrite(qt, reg_key_4_NTHR, qt.NTHR[4]);
    qtWrite(qt, reg_key_5_NTHR, qt.NTHR[5]);
    qtWrite(qt, reg_key_6_NTHR, qt.NTHR[6]);
    qtWrite(qt, reg_key_7_NTHR, qt.NTHR[7]);
    qtWrite(qt, reg_key_8_NTHR, qt.NTHR[8]);
    qtWrite(qt, reg_key_9_NTHR, qt.NTHR[9]);
    qtWrite(qt, reg_key_10_NTHR, qt.NTHR[10]);
    qtWrite(qt, reg_key_11_NTHR, qt.NTHR[11]);
    qtWrite(qt, reg_key_12_NTHR, qt.NTHR[12]);
    qtWrite(qt, reg_key_13_NTHR, qt.NTHR[13]);
    qtWrite(qt, reg_key_14_NTHR, qt.NTHR[14]);
    qtWrite(qt, reg_key_15_NTHR, qt.NTHR[15]);
    //******************BL registers****************************//
    qtWrite(qt, reg_key_0_BL, qt.BL[0]);
    qtWrite(qt, reg_key_1_BL, qt.BL[1]);
    qtWrite(qt, reg_key_2_BL, qt.BL[2]);
    qtWrite(qt, reg_key_3_BL, qt.BL[3]);
    qtWrite(qt, reg_key_4_BL, qt.BL[4]);
    qtWrite(qt, reg_key_5_BL, qt.BL[5]);
    qtWrite(qt, reg_key_6_BL, qt.BL[6]);
    qtWrite(qt, reg_key_7_BL, qt.BL[7]);
    qtWrite(qt, reg_key_8_BL, qt.BL[8]);
    qtWrite(qt, reg_key_9_BL, qt.BL[9]);
    qtWrite(qt, reg_key_10_BL, qt.BL[10]);
    qtWrite(qt, reg_key_11_BL, qt.BL[11]);
    qtWrite(qt, reg_key_12_BL, qt.BL[12]);
    qtWrite(qt, reg_key_13_BL, qt.BL[13]);
    qtWrite(qt, reg_key_14_BL, qt.BL[14]);
    qtWrite(qt, reg_key_15_BL, qt.BL[15]);

    qtWrite(qt, reg_negRecalDelay, qt.NRD);

    qtWrite(qt, reg_calibrate, 0);
}

void QTread(QT &qt)
{
    char write_data[5];
    write_data[0] = reg_generalStatus;
    qt.i2c.write(qt.ADDR, write_data, 1);
    wait_ms(1);
    qt.i2c.read(qt.ADDR, qt.readData.all, 5);
    wait_ms(1);
}

#endif