#include "mbed.h"
#include "QT2160.h"

I2C i2c(p28, p27);
DigitalOut myled1(LED1);
InterruptIn change1(p14);
Serial pc(USBTX, USBRX);
int temp=1;

QT S1 = {
    i2c,
    (0x44 << 1),
    1,
    1,
    20,
    5,
    2,
    50,
    25,
    8,
    0,
    {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0},
    {7, 7, 7, 7, 7, 7, 7, 7, 10, 10, 10, 10, 10, 10, 10, 10},
    {40, 40, 40, 40, 40, 40, 40, 40, 0, 0, 0, 0, 0, 0, 0, 0}

};

void readS1()
{
    QTread(S1);
    printf("%d \n", S1.readData.Regs.sliderTouchPosition);
}

int main()
{

    pc.baud(230400);
    i2c.frequency(100000); // I2C init
    printf("Initializing \n");
    QTSetup(S1);
    printf("QT1 configured \n");
    change1.fall(&readS1);
    change1.mode(PullUp);
    readS1();
    while (1)
    {

        wait_ms(1);
    }
}
