#include "mbed.h"
#include "ADE9000.h"
DigitalOut CS(p14);
#define MOSI_pin p11
#define MISO    p12
#define SCLK_pin p13
SPI spi(p11, p12, p13); // mosi, miso, sclk

 DigitalOut myled(LED1);

#define ADE9000_Reset_wait_ms_Value 10000
#define ADE9000_SS_wait_ms_Value 1000
#define ADE9000_Comu_Delay_Value 1
#define ADE9000_Start_Delay_Value 10

void Init_ADE9000(void);
void Read_ADE9000_SPI(uint16_t  us_ADE_Addr, uint16_t us_Nr_Bytes, uint8_t *puc_Reg_Data);
uint16_t Read_ADE9000_CRC_SPI(uint16_t  us_ADE_Addr, uint16_t us_Nr_Bytes, uint8_t *puc_Reg_Data);
void Write_ADE9000_SPI(uint16_t  us_ADE_Addr, uint8_t uc_Nr_Bytes, uint8_t *puc_Reg_Data);
void Read_OTest_ADE9000_SPI(uint16_t  us_ADE_Addr, uint16_t us_Nr_Bytes, uint8_t *puc_Reg_Data);

void printReadData(uint8_t length);
void int2bin( int value, char* buffer, int bufferSize);
long decConvert(uint8_t length);
void readData();
//uint8_t IsADE9078OrADE9000(void);
uint8_t uc_ADEChipID;

uint8_t uc_Read_Data[4];
uint8_t uc_Write_Data[4];

// const byte CS = 53;
// const byte MOSI_pin=51;
// const byte SCLK_pin = 52;

long data = 0;



void configure()
{
 // uint8_t bitRead;

   //wait for reset after power on 
  printf("Initializing ADE\n");
  wait_ms(2000);

  //Read PGA gain
  printf("2. PGA gain\n");
  Read_ADE9000_SPI(ADDR_PGA_GAIN,0x2,uc_Read_Data);
  printReadData(0x02);

 // Read config0
  printf("4-7 Config0\n");
  uc_Write_Data[0]=0b0;
  uc_Write_Data[1]=0b0;
  uc_Write_Data[2]=0b0;
  uc_Write_Data[3]=0b0;
  Write_ADE9000_SPI(ADDR_CONFIG0,0x04,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_CONFIG0,0x04,uc_Read_Data);
  printReadData(0x04);

//read config 2
  printf("CONFIG2\n");
  Read_ADE9000_SPI(ADDR_CONFIG2,0x04,uc_Read_Data);
  printReadData(0x04);

 // Write dynamic range adjustment
  printf("VLEVEL\n");
  uc_Write_Data[0]=0b0;
  uc_Write_Data[1]=0b00001000;
  uc_Write_Data[2]=0b11000010;
  uc_Write_Data[3]=0b01011010;
  Write_ADE9000_SPI(ADDR_VLEVEL,0x04,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_VLEVEL,0x04,uc_Read_Data);
  printReadData(0x04);

 // vconsel adjust
  printf("VCONSEL IN ACCMODE\n");
Read_ADE9000_SPI(ADDR_ACCMODE,0x02,uc_Read_Data);
  printReadData(0x02);



  //Callibrate AIGAIN
  printf("AIGAIN\n");
  uc_Write_Data[0]=0b0;
  uc_Write_Data[1]=0b11001100;
  uc_Write_Data[2]=0b11001100;
  uc_Write_Data[3]=0b11001101;
  Write_ADE9000_SPI(ADDR_AIGAIN,0x04,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_AIGAIN,0x04,uc_Read_Data);
  printReadData(0x04);


//Callibrate BIGAIN
  printf("BIGAIN\n");
  uc_Write_Data[0]=0b0;
  uc_Write_Data[1]=0b10001110;
  uc_Write_Data[2]=0b01111010;
  uc_Write_Data[3]=0b10110111;
  Write_ADE9000_SPI(ADDR_BIGAIN,0x04,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_BIGAIN,0x04,uc_Read_Data);
  printReadData(0x04);

//Callibrate CIGAIN
  printf("CIGAIN\n");
  uc_Write_Data[0]=0b0;
  uc_Write_Data[1]=0b11111011;
  uc_Write_Data[2]=0b11001000;
  uc_Write_Data[3]=0b10010110;
  Write_ADE9000_SPI(ADDR_CIGAIN,0x04,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_CIGAIN,0x04,uc_Read_Data);
  printReadData(0x04);

  //Callibrate NIGAIN
  printf("NIGAIN\n");
  uc_Write_Data[0]=0b10;
  uc_Write_Data[1]=0b01010110;
  uc_Write_Data[2]=0b00101101;
  uc_Write_Data[3]=0B10111001;
  Write_ADE9000_SPI(ADDR_NIGAIN,0x04,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_NIGAIN,0x04,uc_Read_Data);
  printReadData(0x04);

  
  //Callibrate AVGAIN
  printf("AVGAIN\n");
  uc_Write_Data[0]=0b00000010;
  uc_Write_Data[1]=0b10001111;
  uc_Write_Data[2]=0b00000001;
  uc_Write_Data[3]=0b10010011;
  Write_ADE9000_SPI(ADDR_AVGAIN,0x04,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_AVGAIN,0x04,uc_Read_Data);
  printReadData(0x04); 
  
  //Callibrate BVGAIN
  printf("BVGAIN\n");
  uc_Write_Data[0]=0b00000010;
  uc_Write_Data[1]=0b10000000;
  uc_Write_Data[2]=0b11000000;
  uc_Write_Data[3]=0b10101011;
  Write_ADE9000_SPI(ADDR_BVGAIN,0x04,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_BVGAIN,0x04,uc_Read_Data);
  printReadData(0x04); 
  
    //Callibrate BVGAIN
  printf("CVGAIN\n");
  uc_Write_Data[0]=0b00000010;
  uc_Write_Data[1]=0b10010000;
  uc_Write_Data[2]=0b10000001;
  uc_Write_Data[3]=0b11010001;
  Write_ADE9000_SPI(ADDR_CVGAIN,0x04,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_CVGAIN,0x04,uc_Read_Data);
  printReadData(0x04); 

 // RUN
  printf("run\n");
  uc_Write_Data[0]=0b0;
  uc_Write_Data[1]=0b1;

  Write_ADE9000_SPI(ADDR_RUN,0x02,uc_Write_Data);
  Read_ADE9000_SPI(ADDR_RUN,0x02,uc_Read_Data);
  printReadData(0x02);

//TEMP CONFIG READ
Read_ADE9000_SPI(ADDR_CVGAIN,0x04,uc_Read_Data);
printf("TEMP_TRIM CONFIG\n");
printReadData(0x04);

}

void printReadData(uint8_t length)
{
    for(int k=0;k<length;k++){
  //  printf(uc_Read_Data[k],BIN);
    char binaryBuffer[9]; // 8 bits plus null terminator
    int2bin(uc_Read_Data[k], binaryBuffer, 9) ;
    printf("%s \n",binaryBuffer);
  }
}

void int2bin( int value, char* buffer, int bufferSize) {
    char *nextChar = buffer + bufferSize-2;            // location to write the least significant bit
   
    for (int i = 0; i<(bufferSize-1); i++) {                    // for each bit
      (value & (1<<i)) ? *nextChar  = '1' : *nextChar  = '0'; // if set set to '1' else '0'
      nextChar --;
    }
   
    *(buffer + bufferSize-1) = 0;  // add the null terminator
  }

long decConvert(uint8_t length)
{
  long temp_data =0;
  for(int i=0;i<length;i++ )
  {
    temp_data = temp_data*256+ uc_Read_Data[i];
  }
  return temp_data;
}




void Read_ADE9000_SPI(uint16_t  us_ADE_Addr, uint16_t us_Nr_Bytes, uint8_t *puc_Reg_Data)
{
  uint16_t us_iCounter;
  uint16_t us_iAddress; 
  uint8_t *puc_TempData;
  uint8_t  uc_LS_Addr,uc_MS_Addr;

//printf("address to read");
//printf(us_ADE_Addr,HEX);
  us_iAddress = us_ADE_Addr;
  us_iAddress = (us_iAddress << 4);
  us_iAddress = (us_iAddress | 0x08);
  puc_TempData = puc_Reg_Data;

    uc_LS_Addr = (uint8_t) us_iAddress;   //captures the least sig 8 bits only
    uc_MS_Addr =(uint8_t) (us_iAddress >> 8); //flush the lsbs and capture the rest
  
  wait_ms(ADE9000_Start_Delay_Value); 
  CS=0;  
  wait_ms(ADE9000_Start_Delay_Value); 
 /* printf("Address read");
  printf("MS addr");
  printf(uc_MS_Addr,BIN);
  printf("LSAddr");
  printf(uc_LS_Addr,BIN);*/
  spi.write(uc_MS_Addr);

  
  //send LS byte of address
  spi.write(uc_LS_Addr);

  //MOSI_pin = 1;  //ADE90xx comm data format: MSB--LSB ; So need send out the MSB first.
 // puc_TempData=puc_TempData+(us_Nr_Bytes-1);

  for (us_iCounter=0;us_iCounter<us_Nr_Bytes;us_iCounter++)
  {
    *puc_TempData=spi.write(0);
    puc_TempData++;
   }
  // MOSI_pin=1;
 //Disable_ADE_CS;;
  CS=1;
  wait_ms(ADE9000_Comu_Delay_Value);  
  //enable back the interrupts because the communcation has finished
  //__enable_interrupt();
  
}

uint8_t IsADE9078OrADE9000(void)
{

  uint8_t uc_Read_Data[4];
  uint8_t uc_iChipID = 0;

  Read_ADE9000_SPI(0x472,0x4,uc_Read_Data);
 
  for(int k=0;k<4;k++){
    printf("Return Byte");
    //printf(k);
  //  printf(uc_Read_Data[k],BIN);
  }
  if(uc_Read_Data[2] == 0x10)
    uc_iChipID = 1;
    

  
  return uc_iChipID;

}

void Write_ADE9000_SPI(uint16_t us_ADE_Addr, uint8_t uc_Nr_Bytes, uint8_t *puc_Reg_Data)
{
  uint8_t uc_iCounter;
  uint16_t us_iAddress;   
    uint8_t uc_MS_Addr;
    uint8_t uc_LS_Addr;

  us_iAddress = us_ADE_Addr;
  us_iAddress = (us_iAddress << 4);
  us_iAddress = (us_iAddress & 0xFFF7);


    uc_LS_Addr = (uint8_t) us_iAddress;
  uc_MS_Addr =(uint8_t) (us_iAddress >> 8);
  
 wait_ms(ADE9000_Start_Delay_Value); 
    //Enable_ADE_CS;
     CS=0;
    wait_ms(ADE9000_Start_Delay_Value); 
    
  
    //send MS byte of address
    spi.write(uc_MS_Addr);
  
    //send LS byte of address
    spi.write(uc_LS_Addr);


    //ADE90xx comm data format: MSB--LSB ; So need send out the MSB first.
    puc_Reg_Data=puc_Reg_Data;
    for(uc_iCounter=0;uc_iCounter<uc_Nr_Bytes;uc_iCounter++)
    {
    spi.write(*puc_Reg_Data);
    puc_Reg_Data++;
    }
    
 // Disable_ADE_CS;
  CS=1;
  wait_ms(ADE9000_Start_Delay_Value);  
    //enable back the interrupts because the communcation has finished
    //__enable_interrupt();
  
}

static unsigned char SPI_MCUReadByte(void) 
{ 

        unsigned char i,rbyte=0;  
  /*
        for(i=0;i<8;i++) //8 bit read
        {  
                Low_ADE_SCLK;  //Simulate clock signal 
                SPI_Delay(ADE9000_Comu_Delay_Value); 
                High_ADE_SCLK;  
        SPI_Delay(ADE9000_Comu_Delay_Value);
                rByte<<=1;  
                rByte|=ADE_MISO_Data; //get read bit from MISO port 
        }  */
        rbyte = spi.write(0);
        return rbyte; //return data
     
}  

void readData(){
    // printf("AVRMS");
     Read_ADE9000_SPI(ADDR_AVRMS,0x04,uc_Read_Data);
      //printReadData(0x04);
     data = decConvert(0x04);
    //printf(data);
      printf("\nAVRMS: ");
    // printf(data);
     float data1 = data*13.416/1000000;
    printf("%f \n",data1);
   //  delay(500);
   
    // printf("BVRMS");
     Read_ADE9000_SPI(ADDR_BVRMS,0x04,uc_Read_Data);
      //printReadData(0x04);
     data = decConvert(0x04);
    //printf(data);
      printf("BVRMS: ");
    //  printf(data);
      data1 = data*13.417/1000000;
    printf("%f \n",data1);
   //  delay(500);
   
   
    // printf("CVRMS");
     Read_ADE9000_SPI(ADDR_CVRMS,0x04,uc_Read_Data);
      //printReadData(0x04);
     data = decConvert(0x04);
    //printf(data);
      printf("CVRMS: ");
     // printf(data);
      data1 = data*13.417/1000000;
    printf("%f \n",data1);
   //  delay(500);
   
   //  printf("AIRMS");
     Read_ADE9000_SPI(ADDR_AIRMS,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
       printf("Current A RMS : ");
      // printf(data);
      data1 = data*2.945/1000000;
     printf("%f \n",data1);
     wait_ms(250);
   
     //  printf("IRMS");
     Read_ADE9000_SPI(ADDR_BIRMS,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
   // printf(data);
     printf("Current B RMS : ");
    // printf(data);
      data1 = data*2.8238/1000000;
     printf("%f \n",data1);
     wait_ms(250);
   
     //  printf("IRMS");
     Read_ADE9000_SPI(ADDR_CIRMS,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
   // printf(data);
     printf("Current C RMS : ");
    // printf(data);
      data1 = data*2.8869/1000000;
     printf("%f \n",data1);
     wait_ms(250);
   
     //  printf("IRMS");
     Read_ADE9000_SPI(ADDR_NIRMS,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
      printf("Current N RMS : ");
     //printf(data);
      data1 = data*6.8815/1000000;
      printf("%f \n",data1);
     wait_ms(250);
   
     //  printf("IRMS");
     Read_ADE9000_SPI(ADDR_CWATT,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
   // printf(data);
     printf("ACTIVE : ");
      data1 = data*11.97/1000;
     printf("%f \n",data1);
     wait_ms(250);
   
       //  printf("IRMS");
     Read_ADE9000_SPI(ADDR_CVAR,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
   // printf(data);
     printf("REACTIVE : ");
      data1 = data*11.97/1000;
     printf("%f \n",data1);
     wait_ms(250);
   
       //  printf("IRMS");
     Read_ADE9000_SPI(ADDR_CVA,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
   // printf(data);
     printf("APPARENT : ");
      data1 = data*11.97/1000;
     printf("%f \n",data1);
     wait_ms(250);
   
         //  printf("IRMS");
     Read_ADE9000_SPI(ADDR_APERIOD,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
   // printf(data);
     printf("AV FREQUENCY : ");
      data1 = (8000.00*65536.00)/(data+1);
     printf("%f \n",data1);
   
     Read_ADE9000_SPI(ADDR_BPERIOD,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
   // printf(data);
     printf("BV FREQUENCY : ");
      data1 = (8000.00*65536.00)/(data+1);
     printf("%f \n",data1);
    
      Read_ADE9000_SPI(ADDR_CPERIOD,0x04,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x04);
   // printf(data);
     printf("CV FREQUENCY : ");
      data1 = (8000.00*65536.00)/(data+1.00);
     printf("%f \n",data1);
     wait_ms(250);
   
   uc_Write_Data[0]= 0b01110000;
   uc_Write_Data[1]=0b0;
     Write_ADE9000_SPI(ADDR_TEMP_CFG,0X02,uc_Write_Data);
      Read_ADE9000_SPI(ADDR_TEMP_RSLT,0x02,uc_Read_Data);
    // printReadData(0x04);
     data = decConvert(0x02);
   // printf(data);
     printf("TEMPERATURE : ");
      data1 = data*(-33233.00/65536.00)+656.00/32.00;
     printf("%f \n",data1);
     wait_ms(250);
   
   
     printf("************************");
   
   }






int main() {

    configure();

    while(1){
        readData();
        myled=!myled;
    }
}