#include "mbed.h"
#include "USBHostMIDI.h"
 
void noteOn(unsigned char channel, unsigned char note, unsigned char velocity) {
    printf("note on channel: %d, note: %d, velocity: %d\r\n", channel, note, velocity);
}

void noteOff(unsigned char channel, unsigned char note, unsigned char velocity) {
    printf("note off channel: %d, note: %d, velocity: %d\r\n", channel, note, velocity);
}

void controlChange(unsigned char channel, unsigned char key, unsigned char value) {
    printf("control change channel: %d, key: %d, value: %d\r\n", channel, key, value);
}

void programChange(unsigned char channel, unsigned char program) {
    printf("progaram change channel: %d, program: %d\r\n", channel, program);
}

void pitchBend(unsigned char channel, unsigned int value) {
    printf("pitch bend channel: %d, value: %d\r\n", channel, value);
}

void midi_task(void const*) {
    USBHostMIDI midi;

    // attach midi event callbacks
    midi.attachNoteOn(noteOn);
    midi.attachNoteOff(noteOff);
    midi.attachControlChange(controlChange);
    midi.attachProgramChange(programChange);
    midi.attachPitchBend(pitchBend);

    while(1) {
        // try to connect a midi device
        while(!midi.connect())
            Thread::wait(500);
        
        // if the device is disconnected, we try to connect it again
        while (1) {
            // if device disconnected, try to connect it again
            if (!midi.connected())
                break;
             
            Thread::wait(50);
        }
    }
}
 
int main() {
    Thread midiTask(midi_task, NULL, osPriorityNormal, 256 * 4);
    while(1) {
        Thread::wait(500);
    }
}