////////////////////////////////////////////////////////////////////////////
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//  Copyright (c) Microsoft Corporation.  All rights reserved.
//  Portions Copyright (c) Kentaro Sekimoto All rights reserved.
//
//  Based on Text-To-Speech for .NET Micro Framework with Microsoft 
//  Translator Service
//  https://code.msdn.microsoft.com/Text-To-Speech-for-NET-9cea4462
//
////////////////////////////////////////////////////////////////////////////

#include "mbed.h"

class AdmAuthentication
{
public:
    AdmAuthentication(char *clientID, char *clientSecret);
    ~AdmAuthentication();
    char *GetAccessToken();
    char *HttpPost(char *DatamarketAccessUri, char *requestDetails);
    
private:
    char *id;
    char *secret;
    char encoded_id[64];
    char encoded_secret[64];
    char request[256];
    char token[1024];
    char url[128];
};