////////////////////////////////////////////////////////////////////////////
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//  Copyright (c) Microsoft Corporation.  All rights reserved.
//  Portions Copyright (c) Kentaro Sekimoto All rights reserved.
//
//  Based on Text-To-Speech for .NET Micro Framework with Microsoft 
//  Translator Service
//  https://code.msdn.microsoft.com/Text-To-Speech-for-NET-9cea4462
//
////////////////////////////////////////////////////////////////////////////

#include "mbed.h"
#include "AdmAuthentication.h"
#include "HTTPClient.h"

#define MAX_DATAIN  1024
#define DATAMARKET_ACCESS_URI "https://datamarket.accesscontrol.windows.net/v2/OAuth2-13"
#define SCOPE   "http://api.microsofttranslator.com"
#define HEADER  "application/x-www-form-urlencoded"
#define TOKENTAG    "access_token"

void urlencode(char *src, char *dst);

static char datain[MAX_DATAIN];
static HTTPText inText(datain, MAX_DATAIN);
static char token_buf[MAX_DATAIN];

char *AdmAuthentication::HttpPost(char *DatamarketAccessUri, char *requestDetails)
{
    HTTPClient hc;
    HTTPText outText(requestDetails);
    outText.setDataType(HEADER);
#ifdef DEBUG_AUTH
    printf("DatamarketAccessUri:%s\r\n", DatamarketAccessUri);
    printf("requestDetails:%s\r\n", requestDetails);
#endif
    hc.post((const char*)DatamarketAccessUri, outText, &inText);
#ifdef DEBUG_AUTH
    printf("inText:%s\r\n", datain);
#endif
    char *pTokenStart = strstr(datain, TOKENTAG);
    if (pTokenStart == NULL) {
        return (char *)NULL;
    }
    pTokenStart += (strlen(TOKENTAG) + 3);
    char *pTokenEnd = strstr(pTokenStart, "\"");
    if (pTokenEnd == NULL) {
        return (char *)NULL;
    }
    strncpy(token_buf, pTokenStart, (pTokenEnd - pTokenStart));
    token_buf[pTokenEnd - pTokenStart] = 0;
#ifdef DEBUG_AUTH
    printf("access_token:%s\r\n", token_buf);
#endif
    return (char *)token_buf;
}

char *AdmAuthentication::GetAccessToken()
{
    return HttpPost((char *)DATAMARKET_ACCESS_URI, request);
}

AdmAuthentication::AdmAuthentication(char *clientID, char *clientSecret)
{
    char encoded_scope[64]; 
    id = clientID;
    secret = clientSecret;
    urlencode(id, encoded_id);
    urlencode(secret, encoded_secret);
    urlencode(SCOPE, encoded_scope);
    sprintf(request, "grant_type=client_credentials&client_id=%s&client_secret=%s&scope=%s", id, encoded_secret, SCOPE);
}

AdmAuthentication::~AdmAuthentication()
{
}
