////////////////////////////////////////////////////////////////////////////
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//  Copyright (c) Microsoft Corporation.  All rights reserved.
//  Portions Copyright (c) Kentaro Sekimoto All rights reserved.
//
//  Convert wave file from 8bit mono to 16 bit stereo
//
////////////////////////////////////////////////////////////////////////////

#include "mbed.h"

#define HEADER_SIZE 0x2e
#define BUF_SIZE    1024
#define TO_BUF_SIZE (FROM_BUF_SIZE * 2)
#define MUL 20

unsigned char fromHeader[HEADER_SIZE];
unsigned char toHeader[HEADER_SIZE];

unsigned char fromBuf[BUF_SIZE];
short toBuf[BUF_SIZE*2];

// 0x25c8 + 0x2e = 0x25f6
void wavecnv(char *fromfn, char *tofn)
{
    FILE *fromfp;
    FILE *tofp;
    int fromSize;
    int toSize;
    unsigned int size;
    int i;
    unsigned int fromChunkSize;
    unsigned int toChunkSize;
    unsigned int sampleRate;
    unsigned short uval;
    short sval;
    if ((fromfp = fopen(fromfn, "rb")) == NULL)
        return;
    if ((tofp = fopen(tofn, "wb")) == NULL)
        return;
    fromSize = fread(fromHeader, 1, HEADER_SIZE, fromfp);
    memcpy(toHeader, fromHeader, HEADER_SIZE);
    sampleRate = (unsigned int)fromHeader[0x18] +
                    ((unsigned int)fromHeader[0x19] << 8) +
                    ((unsigned int)fromHeader[0x1a] << 16) +
                    ((unsigned int)fromHeader[0x1b] << 24) ;
    sampleRate *= 4;
    toHeader[0x1c] = (unsigned char)(sampleRate & 0xff);
    toHeader[0x1d] = (unsigned char)((sampleRate >> 8) & 0xff);
    toHeader[0x1e] = (unsigned char)((sampleRate >> 16) & 0xff);
    toHeader[0x1f] = (unsigned char)((sampleRate >> 24) & 0xff);
    toHeader[0x10] = 0x10;
    toHeader[0x16] = 0x02;
    toHeader[0x20] = 0x04;
    toHeader[0x22] = 0x10;
    fromChunkSize = (unsigned int)fromHeader[0x2a] +
                    ((unsigned int)fromHeader[0x2b] << 8) +
                    ((unsigned int)fromHeader[0x2c] << 16) +
                    ((unsigned int)fromHeader[0x2d] << 24) ;
    toChunkSize = fromChunkSize * 4;
    toHeader[0x24] = 'd';
    toHeader[0x25] = 'a';
    toHeader[0x26] = 't';
    toHeader[0x27] = 'a';
    toHeader[0x28] = (unsigned char)(toChunkSize & 0xff);
    toHeader[0x29] = (unsigned char)((toChunkSize >> 8) & 0xff);
    toHeader[0x2a] = (unsigned char)((toChunkSize >> 16) & 0xff);
    toHeader[0x2b] = (unsigned char)((toChunkSize >> 24) & 0xff);
    size = toChunkSize + 0x2c - 8;
    toHeader[0x04] = (unsigned char)(size & 0xff);
    toHeader[0x05] = (unsigned char)((size >> 8) & 0xff);
    toHeader[0x06] = (unsigned char)((size >> 16) & 0xff);
    toHeader[0x07] = (unsigned char)((size >> 24) & 0xff);
    toSize = fwrite(toHeader, 1, HEADER_SIZE, tofp);
    while (fromChunkSize > 0) {
        if (fromChunkSize > BUF_SIZE)
            size = BUF_SIZE;
        else
            size = fromChunkSize;
        fromSize = fread(fromBuf, 1, size, fromfp);
        for (i = 0; i < size; i++) {
            if (fromBuf[i] == 0x80) {
                toBuf[i*2] = 0;
                toBuf[i*2+1] = 0;
            } else {
                uval = (unsigned short)fromBuf[i];
                if (uval > 0x80) {
                    uval = (uval - 0x80) * 256;
                    sval = (short)uval;
                } else {
                    uval = (0x80 - uval) * 256;
                    sval = ((short)uval) * (-1);
                }
                toBuf[i*2] = sval;
                toBuf[i*2+1] = sval;
            }
        }
        toSize = fwrite(toBuf, 4, size, tofp);
        fromChunkSize -= size;
    }
    fclose(tofp);
    fclose(fromfp);
}