////////////////////////////////////////////////////////////////////////////
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//  Copyright (c) Microsoft Corporation.  All rights reserved.
//  Portions Copyright (c) Kentaro Sekimoto All rights reserved.
//
////////////////////////////////////////////////////////////////////////////

#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "getline.h"
#include "SpeechSynthesizer.h"
#include "TLV320_RBSP.h"
#include "dec_wav.h"
#include "SDFileSystem.h"

//#define SPEECH_TEXT "hello"
#define SPEECH_TEXT "I will explain Cloud Speech Application."
 
void wavecnv(char *fromfn, char *tofn);
SDFileSystem sd(P8_5, P8_6, P8_3, P8_4, "sd");
 
namespace {
const char *sd_file_path = "/sd/out.txt";
const int DATA_SIZE = 256;
}

#ifdef USBFS
#include "USBHostMSD.h"
#if defined(TARGET_RZ_A1H)
#include "usb_host_setting.h"
#else
#define USB_HOST_CH     0
#endif
#if (USB_HOST_CH == 1) //Audio Shield USB1
DigitalOut usb1en(P3_8);
#endif
#endif

#ifdef ROMRAMFS
#include "RomRamFileSystem.h"
#endif

#define AUDIO_WRITE_BUFF_SIZE  (4096)
#define AUDIO_WRITE_BUFF_NUM   (9)
#define FILE_NAME_LEN          (64)
#define TEXT_SIZE              (64 + 1) //null-terminated

#define CLIENT_ID       "xxxxxx"                        // need to register Azure
#define CLIENT_SECRET   "yyyyyyyyyyyyyyyyyyyyyyyyyyyy"  // need to register Azure  
#ifdef ROMRAMFS
#define WAVE_MEM_FN "/romram/speech.wav"
#endif
#ifdef USBFS
#define WAVE_USB_FN "/usb/speech.wav"
#endif
#define WAVE_SD_FN "/sd/speech8.wav"
#define WAVE_SD_FN1 "/sd/speech16.wav"

EthernetInterface eth;
#ifdef USBFS
USBHostMSD msd("usb");
#endif
#ifdef ROMRAMFS
RomRamFileSystem romramfs("romram");
#endif
HTTPClient http;
//char recvBuff[1024*20];
      
#ifdef ROMRAMFS  
static void mount_romramfs(void) {
    FILE * fp;
    romramfs.format();
}
#endif

static void callback_audio_write_end(void * p_data, int32_t result, void * p_app_data)
{
    if (result < 0) {
        //printf("audio write callback error %d\n", result);
    }
}

void wav_play(TLV320_RBSP *audio, char *filename)
{
//4 bytes aligned! No cache memory
static uint8_t audio_write_buff[AUDIO_WRITE_BUFF_NUM][AUDIO_WRITE_BUFF_SIZE] __attribute((section("NC_BSS"),aligned(4)));
static uint8_t title_buf[TEXT_SIZE];
static uint8_t artist_buf[TEXT_SIZE];
static uint8_t album_buf[TEXT_SIZE];

    dec_wav wav_file;
    size_t audio_data_size;
    rbsp_data_conf_t audio_write_async_ctl = {&callback_audio_write_end, NULL};

    FILE *fp = fopen(filename, "r");
    if (fp == NULL) {
        printf("Can't open %s\r\n", filename);
        return;
    } 
    if (wav_file.AnalyzeHeder(title_buf, artist_buf, album_buf, TEXT_SIZE, fp) == false) {
        printf("WAV format not supported. (%s)\r\n", filename);
        printf("Error File  :%s\r\n", filename);
        printf("Audio Info  :%dch, %dbit, %dHz\r\n", 
            wav_file.GetChannel(), wav_file.GetBlockSize(), wav_file.GetSamplingRate());
        fclose(fp);
    } else if ((wav_file.GetChannel() != 2)
        || (audio->format(wav_file.GetBlockSize()) == false)
        || (audio->frequency(wav_file.GetSamplingRate()) == false)) {
        printf("WAV format not supported. (%s)\r\n", filename);
        printf("Audio Info  :%dch, %dbit, %dHz\r\n", 
            wav_file.GetChannel(), wav_file.GetBlockSize(), wav_file.GetSamplingRate());
        fclose(fp);
    } else {
        printf("File        :%s\r\n", filename);
        printf("Audio Info  :%dch, %dbit, %dHz\r\n", 
            wav_file.GetChannel(), wav_file.GetBlockSize(), wav_file.GetSamplingRate());
        //printf("Title       :%s\r\n", title_buf);
        //printf("Artist      :%s\r\n", artist_buf);
        //printf("Album       :%s\r\n", album_buf);

        int buff_index = 0;
        while (1) {
            uint8_t *p_buf = audio_write_buff[buff_index];
            audio_data_size = wav_file.GetNextData(p_buf, AUDIO_WRITE_BUFF_SIZE);
            if (audio_data_size > 0) {
                audio->write(p_buf, audio_data_size, &audio_write_async_ctl);
                buff_index++;
            }
            if (buff_index >= AUDIO_WRITE_BUFF_NUM) {
                buff_index = 0;
            }
            if ((audio_data_size < AUDIO_WRITE_BUFF_SIZE)) {
                break;
            }
        }
        fclose(fp);
    }    
}

void net_main(void const *av)
{
    int ret ;
    char key[100] ;
    char *translated;

    eth.init(); //Use DHCP
    printf("HTTP Client, Starting,...\r\n") ;
    while(1) {
        if(eth.connect() == 0)break ;
        printf("Retry\n") ;
    }
    SpeechSynthesizer speech = SpeechSynthesizer(CLIENT_ID, CLIENT_SECRET);
    speech.UpdateToken();
    translated = speech.Translate(SPEECH_TEXT, "ja");
    speech.GetSpeakStream(WAVE_SD_FN, translated, "ja");
    getline("Hit any key to start!\r\n", key, sizeof(key));
    wavecnv(WAVE_SD_FN, WAVE_SD_FN1);
    
    TLV320_RBSP audio(P10_13, I2C_SDA, I2C_SCL, P4_4, P4_5, P4_7, P4_6, 0x80, (AUDIO_WRITE_BUFF_NUM - 1), 0);
    audio.power(0x02); // mic off
    audio.inputVolume(0.7, 0.7);
    while(1) {
        char key[10];
        wav_play(&audio, WAVE_SD_FN1);
        getline("Hit any key to start!\r\n", key, sizeof(key));
    }
}

main()
{
#ifdef USBFS
#if (USB_HOST_CH == 1) //Audio Shield USB1
    //Audio Shield USB1 enable
    usb1en = 1;        //Outputs high level
    Thread::wait(5);
    usb1en = 0;        //Outputs low level
#endif
    USBHostMSD msd("usb");
#endif

#ifdef ROMRAMFS
    mount_romramfs();
#endif
#define STACK_SIZE 24000
    Thread t(net_main, NULL, osPriorityNormal, STACK_SIZE);
    while (true) {
        Thread::wait(1000);
    }
}
