////////////////////////////////////////////////////////////////////////////
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//  Copyright (c) Microsoft Corporation.  All rights reserved.
//  Portions Copyright (c) Kentaro Sekimoto All rights reserved.
//
//  Based on Text-To-Speech for .NET Micro Framework with Microsoft 
//  Translator Service
//  https://code.msdn.microsoft.com/Text-To-Speech-for-NET-9cea4462
//
////////////////////////////////////////////////////////////////////////////

#include "mbed.h"

class SpeechSynthesizer
{
public:
    SpeechSynthesizer(const char *clientID, const char *clientSecret);
    void GetSpeakStream(char *filename, char *text, char *language);
    void UpdateToken();
    char *Translate(char *text, char *to);
    ~SpeechSynthesizer();
private:
    char *id;
    char *secret;
    char *language;
    char *audioFormat;
    char *audioQuality;
    char token[512];
};
