#include "KeyboardLed.h"

KeyboardLed::KeyboardLed(unsigned char ucColumn)
{
    pKeyboard = new Keyboard(ucColumn);
    pLedboard = new Ledboard(ucColumn);
}

enum KeyboardState KeyboardLed::eRead()
{
    switch(pKeyboard->eRead()) 
    {
        case BUTTON_0:
            pLedboard->On(0);
            return BUTTON_0;
        case BUTTON_1:
            pLedboard->On(1);
            return BUTTON_1;
        case BUTTON_2:
            pLedboard->On(2);
            return BUTTON_2;
        case BUTTON_3:
            pLedboard->On(3);
            return BUTTON_3;
        default:
            pLedboard->Off();
            return RELEASED;
    }   
}