#include "Led_Lcd.h"

LedLcd::LedLcd(unsigned char ucMode)
{
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetFont(&Font24);
    ucButtonsColumn = 80*ucMode;
}

void LedLcd::On(unsigned char ucLedNumber)
{
    for(unsigned char ucCounter = 0; ucCounter < 4; ucCounter++)
    {
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(ucButtonsColumn, 80*ucCounter, 80, 80);
        if(ucLedNumber == ucCounter)
            lcd.SetTextColor(LCD_COLOR_YELLOW);
        else
            lcd.SetTextColor(LCD_COLOR_BLUE);
        
        lcd.FillRect(ucButtonsColumn+1, 80*ucCounter+1, 78, 78);
    } 
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.DisplayStringAt(ucButtonsColumn+1, LINE(0), (uint8_t *)"1", LEFT_MODE);
    lcd.DisplayStringAt(ucButtonsColumn+1, LINE(3.35), (uint8_t *)"2", LEFT_MODE);
    lcd.DisplayStringAt(ucButtonsColumn+1, LINE(6.7), (uint8_t *)"3", LEFT_MODE);
    lcd.DisplayStringAt(ucButtonsColumn+1, LINE(10), (uint8_t *)"4", LEFT_MODE);
}