#include "Ledboard.h"

extern LCD_DISCO_F429ZI lcd;

Ledboard::Ledboard(unsigned char ucColumn)
{
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetFont(&Font24);
    for(unsigned char ucRow = 0; ucRow < 4; ucRow++)
        Leds[ucRow] = new Led(ucColumn, ucRow);   
    Off();
}

void Ledboard::Off()
{
    for(unsigned char ucRow = 0; ucRow < 4; ucRow++)
        Leds[ucRow]->Off();
}

void Ledboard::On(unsigned char ucRowNumber)
{
    Off();
    Leds[ucRowNumber]->On();
}