#include "Led.h"

extern LCD_DISCO_F429ZI lcd;

Led::Led(unsigned char ucColumn, unsigned char ucRow)
{
    this->ucColumn = ucColumn;
    this->ucRow = ucRow;
}
void Led::Redraw(uint32_t Color)
{
    char cLedNumber[2] = {'0' + ucRow};
    char *pLedNumber = cLedNumber;  
    lcd.SetTextColor(Color);
    lcd.FillRect(80*ucColumn+1, 80*ucRow+1, 78, 78);   
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(80*ucColumn, 80*ucRow, 80, 80); 
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(80*ucColumn+1, 80*ucRow, (uint8_t *)pLedNumber, LEFT_MODE);     
}

void Led::On()
{
    Redraw(LCD_COLOR_YELLOW);
}

void Led::Off()
{
    Redraw(LCD_COLOR_BLUE);
}