#include "Keyboard_Ts.h"

KeyboardTs::KeyboardTs(unsigned char ucMode)
{
    ts.Init(240, 320);
    if(ucMode == 1)
        ucTouchscreenColumn = 80;
    else if(ucMode == 2)
        ucTouchscreenColumn = 160;
    else
        ucTouchscreenColumn = 0;          
}

enum KeyboardState KeyboardTs::eRead()
{
    ts.GetState(&TS_State);
    if(TS_State.TouchDetected)
    {
        if((TS_State.X > ucTouchscreenColumn) && (TS_State.X < ucTouchscreenColumn+80))
        {   
            if(TS_State.Y < 80)
                return BUTTON_0;
            else if((TS_State.Y > 80) && (TS_State.Y < 160))
                return BUTTON_1;               
            else if((TS_State.Y > 160) && (TS_State.Y < 240))
                return BUTTON_2;                      
            else if(TS_State.Y > 240)
                return BUTTON_3;
            else
                return RELEASED;
        }
        else
            return RELEASED;
    }
    else
        return RELEASED;
}
