#include "Servo.h"

Servo::Servo(unsigned int uiInitialPosition) :MyGui(uiInitialPosition)
{  
    uiDesiredPosition = uiInitialPosition;
    uiCurrentPosition = uiInitialPosition;
}

enum DetectorState Servo::eReadDetector()
{
    return MyGui.eDetectorRead();
}

void Servo::Callib()
{
    eState = CALLIB;
    while(eState != IDLE)
    {
        if(uiCurrentPosition == 0)
            uiCurrentPosition = 359;
        else
            uiCurrentPosition--;
        MyGui.DetectorStepLeft();
        wait(0.05);
        MyGui.LedStepLeft();
        if(eReadDetector() == ACTIVE)
            eState = IDLE;
        else
            eState = CALLIB;
    }
}

void Servo::GoTo(unsigned int uiPosition)
{
    uiDesiredPosition = uiPosition;
    eState = IN_PROGRESS;
    while(eState != IDLE)
    {
        if(uiCurrentPosition < uiDesiredPosition)
        {
            uiCurrentPosition++;
            MyGui.DetectorStepRight();
            wait(0.05);
            MyGui.LedStepRight();
            eState = IN_PROGRESS;
        }
        else if(uiCurrentPosition > uiDesiredPosition)
        {
            uiCurrentPosition--;
            MyGui.DetectorStepLeft();
            wait(0.05);
            MyGui.LedStepLeft();
            eState = IN_PROGRESS;
        }
        else
            eState = IDLE;        
    }
}

void Servo::Automat()
{  
    switch(eState)
    {
    case CALLIB:
        if(eReadDetector() == INACTIVE)
            MyGui.LedStepLeft();
        else
            eState = IDLE;
        break;
    case IDLE:
        if(uiCurrentPosition != uiDesiredPosition)
            eState = IN_PROGRESS;
        else
            eState = IDLE;
        break;
    case IN_PROGRESS:
        if(uiCurrentPosition < uiDesiredPosition)
        {
            MyGui.LedStepRight();
            uiCurrentPosition++;
            eState = IN_PROGRESS;
        }
        else if(uiCurrentPosition > uiDesiredPosition)
        {
            MyGui.LedStepLeft();
            uiCurrentPosition--;
            eState = IN_PROGRESS;
        }
        else
            eState = IDLE;
        break;
    }
}
