#include "Servo.h"
#include "FunkcjeUART.h"
#include "Tokeny.h"

DigitalIn DetectorSignal(USER_BUTTON);
Serial pc(USBTX, USBRX);

unsigned char ucTokenNr;
struct Token asToken[MAX_TOKEN_NR];
struct Keyword asKeywordList[MAX_KEYWORD_NR] = 
{
    {ID, "id"},
    {CAL, "callib"},
    {GT, "goto"},
    {ST, "step"}
};

Servo MyServo;

int main()
{
    char cString[MAX_KEYWORD_STRING_LTH];
    while (true)
    {
        gets(cString, MAX_KEYWORD_STRING_LTH);
        DecodeMsg(cString);
        if((asToken[0].eType == KEYWORD) && (ucTokenNr > 0))
        {
            if((asToken[0].uValue.eKeyword == ID) && (ucTokenNr == 1))
            {
                puts("id anyidentifier", 16);
            }
            else if((asToken[0].uValue.eKeyword == CAL) && (ucTokenNr == 1))
            {
                puts("ok", 2);
                MyServo.Callib();
            }
            else if((asToken[0].uValue.eKeyword == GT) && (asToken[1].eType == NUMBER))
            {
                puts("ok", 2);
                MyServo.GoTo(asToken[1].uValue.uiNumber);
            }
            else if((asToken[0].uValue.eKeyword == ST) && (asToken[1].eType == NUMBER))
            {
                puts("ok", 2);
                MyServo.GoTo(MyServo.uiCurrentPosition+asToken[1].uValue.uiNumber);             
            }
            else
                puts("unknowncommand", 14);
        }
        else
            puts("unknowncommand", 14);
    }
}