#ifndef SERVO_GUI_H
    #define SERVO_GUI_H
    #include "LCD_DISCO_F429ZI.h"
    enum Direction{LEFT, RIGHT};
    enum DetectorState{ACTIVE, INACTIVE};
    class ServoGui
    {
        public:
            ServoGui(unsigned int uiDetectorInitialPosition = 0);
            void LedStepLeft(void);
            void LedStepRight(void);    
            void DetectorStepLeft(void);
            void DetectorStepRight(void); 
            DetectorState eDetectorRead(void);
        private:
            LCD_DISCO_F429ZI lcd; 
            unsigned char ucLedPosition;
            unsigned int uiDetectorPosition;
            void DrawBackground(void);
            void DrawMotor(void);
            void DrawDetectorPosition(unsigned int uiPosition);
            void DrawLeds(void);
            void ClearLeds(void);
            void SetLed(unsigned char ucLedNumber);
            void StepLed(Direction eDirection);           
    };
#else
    #error "This class was definied previously"
#endif
