#include "ServoGui.h"
#define PI (3.1415)

extern DigitalIn DetectorSignal; 

void ServoGui::DrawBackground()
{
    lcd.Clear(LCD_COLOR_WHITE);
}

void ServoGui::DrawMotor()
{
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.FillCircle(120, 100, 80);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillCircle(120, 100, 15);  
}

DetectorState ServoGui::eDetectorRead(void)
{
    if(DetectorSignal == 1)
        return ACTIVE;
    else 
        return INACTIVE;
}

void ServoGui::DrawDetectorPosition(unsigned int uiPosition)
{
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DrawLine(120, 100, 120+80*cos(0.5*PI+uiPosition*PI/180), 100+80*sin(0.5*PI+uiPosition*PI/180));       
}

void ServoGui::DrawLeds()
{
    lcd.SetTextColor(LCD_COLOR_BLACK);
    unsigned char ucLedXposition =  55;
    for(unsigned char ucLedCounter = 0; ucLedCounter < 4; ucLedCounter++, ucLedXposition+=40)
        lcd.DrawCircle(ucLedXposition, 240, 15);   
}

ServoGui::ServoGui(unsigned int uiDetectorInitialPosition)
{
    DrawBackground();
    DrawMotor();
    DrawLeds();
    DrawDetectorPosition(uiDetectorInitialPosition % 360);
    uiDetectorPosition = uiDetectorInitialPosition % 360;
} 

void ServoGui::ClearLeds()
{
    lcd.SetTextColor(LCD_COLOR_WHITE);
    unsigned char ucLedXposition =  55;
    for(unsigned char ucLedCounter = 0; ucLedCounter < 4; ucLedCounter++, ucLedXposition+=40)
        lcd.FillCircle(ucLedXposition, 240, 14);   
}

void ServoGui::SetLed(unsigned char ucLedNumber)
{
    ClearLeds();
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillCircle(55+40*ucLedNumber, 240, 14); 
}

void ServoGui::StepLed(Direction eDirection)
{
    if(eDirection == LEFT)
        ucLedPosition = (ucLedPosition+3) % 4;
    else if(eDirection == RIGHT)
        ucLedPosition = (ucLedPosition+1) % 4;
    else
        ucLedPosition = ucLedPosition;
    SetLed(ucLedPosition);
}

void ServoGui::LedStepLeft()
{
    StepLed(LEFT);
}

void ServoGui::LedStepRight()
{
    StepLed(RIGHT);
}

void ServoGui::DetectorStepLeft()
{
    if(uiDetectorPosition == 0)
        uiDetectorPosition = 359;
    else
        uiDetectorPosition--;
    DrawMotor();
    wait(0.001);
    DrawDetectorPosition(uiDetectorPosition);  
}

void ServoGui::DetectorStepRight()
{
    uiDetectorPosition = (uiDetectorPosition+1) % 360;
    DrawMotor();
    wait(0.001);
    DrawDetectorPosition(uiDetectorPosition);  
}
