#ifndef TOKENY_H
    #define TOKENY_H
    #include <string.h>
    #include <cstring>
    #include <stdlib.h>
    #include <stdio.h>
    #define MAX_TOKEN_NR 2 //maksymalna dopuszczalna ilosc tokenów
    #define MAX_KEYWORD_STRING_LTH 13 // maksymalna dlugosc komendy
    #define MAX_KEYWORD_NR 4
    #define NULL 0
    
    enum KeywordCode {ID, CAL, GT, ST};
    enum TokenType { KEYWORD, NUMBER, STRING};
    enum Stan{DELIMITER, TOKEN};
    
    union TokenValue
    {
        enum KeywordCode eKeyword; // jezeli KEYWORD
        unsigned int uiNumber; // jezeli NUMBER
        char * pcString; // jezeli STRING
    };

    struct Token
    {
        enum TokenType eType; // KEYWORD, NUMBER, STRING
        union TokenValue uValue; // enum, unsigned int, char*
    };

    struct Keyword
    {
        enum KeywordCode eCode;
        char cString[MAX_KEYWORD_STRING_LTH + 1];
    };
    
    unsigned char ucFindTokensInString (char *pcString);
    enum Result eStringToKeyword (char pcStr[], enum KeywordCode *peKeywordCode);
    void DecodeTokens(void);
    void DecodeMsg(char *pcString);
    
#endif
