#include "Tokeny.h"

enum Result{OK, ERROR};

extern unsigned char ucTokenNr;
extern struct Token asToken[MAX_TOKEN_NR];
extern struct Keyword asKeywordList[MAX_KEYWORD_NR];

/*
void ReplaceCharactersInString(char pcString[], char cOldChar, char cNewChar)
{
        char *pcStringCharacters = pcString;
        pcStringCharacters = strchr(pcStringCharacters, cOldChar);
        while(pcStringCharacters != NULL)
        {
                *pcStringCharacters = cNewChar;
                pcStringCharacters = strchr(pcStringCharacters+1, cOldChar);
        }
}


enum Result eHexStringToUInt(char pcStr[], unsigned int *puiValue)
{
    unsigned char ucCharCounter;
    if((strncmp(pcStr, "0x", 2) != 0) || (strlen(pcStr)) != 6) 
    {
            return ERROR;
    }
    for(ucCharCounter = 2; ucCharCounter < 6; ucCharCounter++)
    {
            if((strncmp(pcStr+ucCharCounter, "0", 1) < 0) || (strncmp(pcStr+ucCharCounter, "F", 1) > 0) || ((strncmp(pcStr+ucCharCounter, "9", 1) > 0) && (strncmp(pcStr+ucCharCounter, "A", 1) < 0))) 
            {   
                    return ERROR;
            }       
    }
    *puiValue = strtol(pcStr, NULL, 0);
        
    return OK;
}
*/
unsigned char ucFindTokensInString (char *pcString)
{
    char *pcTokenStart = pcString;
    ucTokenNr = 0;
    pcTokenStart = strtok(pcString, " ");
    while((pcTokenStart != NULL) && (ucTokenNr < MAX_TOKEN_NR))
    {      
            asToken[ucTokenNr].uValue.pcString = pcTokenStart;
            ucTokenNr++;     
            pcTokenStart = strchr(pcTokenStart, ' ');
            pcTokenStart = strtok(pcTokenStart, " ");
    }

    return ucTokenNr;
}

enum Result eStringToKeyword (char pcStr[], enum KeywordCode *peKeywordCode)
{
        unsigned char ucKeywordListCounter;
        
        for(ucKeywordListCounter = 0; ucKeywordListCounter < MAX_KEYWORD_NR; ucKeywordListCounter++)
        {
                if(strcmp(pcStr, asKeywordList[ucKeywordListCounter].cString) == 0) 
                {
                        *peKeywordCode = asKeywordList[ucKeywordListCounter].eCode;
                        return OK;
                }
        }
        return ERROR;
}

void DecodeTokens(void)
{
        unsigned int uiTokenNumber;
        unsigned char ucTokenListCounter;
        struct Token *TokenValue;

        for(ucTokenListCounter = 0; ucTokenListCounter < ucTokenNr; ucTokenListCounter++)
        {
            TokenValue = &asToken[ucTokenListCounter];
            if( eStringToKeyword(TokenValue->uValue.pcString, &TokenValue->uValue.eKeyword) == OK )
            {
                    TokenValue->eType = KEYWORD;
            }
            else if (sscanf(asToken[ucTokenListCounter].uValue.pcString, "%4x", &uiTokenNumber) == 1) 
            //else if( eHexStringToUInt(TokenValue->uValue.pcString, &TokenValue->uValue.uiNumber) == OK )
            {
                    TokenValue->eType = NUMBER;
                    TokenValue->uValue.uiNumber = uiTokenNumber;
            }
            else
            {
                    TokenValue->eType = STRING;
            }
        }
}

void DecodeMsg(char *pcString)
{
        ucFindTokensInString(pcString);
        DecodeTokens();
}


