/*
 * =============================================================================
 * Rotary Pulse Generator class (Version 1.0.0)
 * =============================================================================
 * Copyright (c) 2012 Christopher Anderson
 * Copyright (c) 2017 Dmitry Makarenko
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */
 
#ifndef MBED_RPG_H
#define MBED_RPG_H

#include "mbed.h"

/**
 * Rotary Pulse Generator class
 *
 */

/**
 * Constructor(Channel A input pin, Channel B input pin, Pushbutton input pin)
 */
class RPG{
    
public:
    RPG(PinName pA, PinName pB, PinName pPB);
    
    //Get Direction 
    int dir();
    
    //Check Push Button
    bool pb();

    
private:
    
    // Channel A
    InterruptIn IA;
    
    // Channel B
    DigitalIn B;
    
    //Push button
    DigitalIn PB;
    
    // Rotation counter (positive value - cw rotation, negative - ccw)
    int m_dir;
    
    // Interrupt handler for channel A, IH for CB is not required
    void onA();
};
#endif