/*
* =============================================================================
* Rotary Pulse Generator class (Version 1.0.0)
* =============================================================================
* Copyright (c) 2012 Christopher Anderson
* Copyright (c) 2017 Dmitry Makarenko
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
* =============================================================================
*/
 
#include "RPG.h"
#include "mbed.h"

/**
 * Constructor(Channel A input pin, Channel B input pin, Pushbutton input pin)
 */
RPG::RPG(PinName pA, PinName pB, PinName pPB)
    : IA(pA), B(pB), PB(pPB), m_dir(0)
    {
        IA.mode(PullUp);
        IA.fall(this, &RPG::onA);
        B.mode(PullUp);
        PB.mode(PullUp);
        wait_us(10);
    }
    
/** 
 * Interrupt handler for channel A.
 * Increments or decrements m_dir depending on channel B state.
 */
void RPG::onA() {
    if(B == 1) {
        m_dir ++;
    }
    else {
        m_dir --;
    }
}

/**
 * Reads and debounces push button returns bool result
 */
bool RPG::pb()
{
    int check = PB;
    wait_us(5);
    if((!check) && !PB)
    {
        return true;
    }
    else return false;
}

/**
 * Direction and amount of rotation since last read:
 * +1 for clockwise
 * -1 for counter-clockwise
 * 0 for no rotation
 */
int RPG::dir()
{
    int tmp = m_dir;
    m_dir = 0;
    return tmp;
}