#include "6LedBar.h"

LedBar::LedBar(PinName p0, PinName p1, PinName p2,
               PinName p3, PinName p4, PinName p5) :
            l0(p0), l1(p1), l2(p2), l3(p3), l4(p4), l5(p5)
{
    m_leds[0] = &l0;
    m_leds[1] = &l1;
    m_leds[2] = &l2;
    m_leds[3] = &l3;
    m_leds[4] = &l4;
    m_leds[5] = &l5;

}

void LedBar::on(int n) {
    if(n < LEDS_COUNT) {
        *(m_leds[n]) = 1;
    }
}

void LedBar::off(int n) {
    if(n < LEDS_COUNT) {
        *(m_leds[n]) = 0;
    }
}

void LedBar::toggle(int n) {
    if(n < LEDS_COUNT) {
        *(m_leds[n]) = ! (*m_leds[n]);
    }
}

void LedBar::on_mask(int m) {
    for(int i = 0; i < LEDS_COUNT; i++) {
        if(m & (1 << i)) {
            on(i);
        }
    }
}

void LedBar::off_mask(int m) {
    for(int i = 0; i < LEDS_COUNT; i++) {
        if(m & (1 << i)) {
            off(i);
        }
    }
}

void LedBar::toggle_mask(int m) {
    for(int i = 0; i < LEDS_COUNT; i++) {
        if(m & (1 << i)) {
            toggle(i);
        }
    }
}

void LedBar::set_mask(int m) {
    for(int i = 0; i < LEDS_COUNT; i++) {
        if(m & (1 << i)) {
            on(i);
        }
        else {
            off(i);
        }
    }
}