#include "mbed.h"
#include "rtos.h"
 
DigitalOut led1(P0_1);
Serial pc(p19, p20);
 
void led1_thread(void const *args) {
    while (true) {
        led1 = !led1;
        Thread::wait(1000);
    }
}
 
 
int main() {


    pc.baud(115200);
    
    NVIC_SetPriority(SSP1_IRQn, 0x0);
    NVIC_SetPriority(PIN_INT0_IRQn, 0x1);
    // SysTick set to lower priority than Wi-Fi SPI bus interrupt
    NVIC_SetPriority(SysTick_IRQn, 0x2);
    
    Thread thread(led1_thread);
    
    while (true) {
        
        pc.printf("main Thread\r\n");
        Thread::wait(500);
    }
}
