#include "mbed.h"
#include "Socket.h"
#include "Endpoint.h"
#include "MTSLog.h"
#include <cstring>

using std::memset;
using namespace mts;

Endpoint::Endpoint()
{
    reset_address();
}

Endpoint::~Endpoint()
{
}

void Endpoint::reset_address(void)
{
    _ipAddress[0] = '\0';
    _port = 0;
}

int Endpoint::set_address(const char* host, const int port)
{
    int length = strlen(host) + 1; // size of host including terminating character
    if (length > sizeof(_ipAddress)) {
        logError("could not set address because the hostname is too long");
        return -1;
    } else {
        strncpy((char*) _ipAddress, host, length);
        _ipAddress[length] = '\0';
        _port = port;
    }
    return 0;
}

char* Endpoint::get_address()
{
    return _ipAddress;
}

int   Endpoint::get_port()
{
    return _port;
}
