/* Karbot motor class
 * Written by Simon Krogedal
 * 27/05/21
 * Team 9 4th Year project
 * 
 * for NUCLEO-F401RE
 * 
 */
 

 #include "motor.h"
 
motor::motor(PinName pwm_pin, PinName dir_pin, double period) : output(pwm_pin), dir(dir_pin), T(period) {
    output.period(T);                   //this period is not going to change during the run
    dir = 1;                            //forward is active high
    dutCyc = 0.1;                       //just need a default value to avoid bugs
    stop();                             //starts off
}

void motor::drive(void) {
    driving = 1;
    output.write(dutCyc);
}

void motor::stop(void) {
    driving = 0;
    output.write(0.0);                              //just constant low
}

void motor::setOut(double dc) {                            //set duty cycle as a number between -1 and 1, where 1 is full force forward, -1 is backwards and 0 is still
    if(dc < 0.0) {
        dir = 0;
        if(dc < -1.0)
            dutCyc = 1.0;
        else
            dutCyc = -dc;
    }
    else {
        dir = 1;
        if(dc > 1.0)
            dutCyc = 1.0;
        else
            dutCyc = dc;
    }
    if(driving)
        output.write(dutCyc);
}

double motor::getPeriod(void) {return T;}

double motor::getDuty(void) {return dutCyc;}

