#ifndef KARBOT_MOTOR_H
#define KARBOT_MOTOR_H

/* Karbot motor class
 * Written by Simon Krogedal
 * 27/05/21
 * Team 9 4th Year project
 * 
 * for NUCLEO-F401RE
 * 
 */
 
 #include "mbed.h"
 
 class motor {
    
    private:
        PwmOut          output;     // PWM output pin
        DigitalOut      dir;        // direction pin
        
        double          T, dutCyc;  // Period and duty cycle variables
        bool            driving;    // flag on wheter the motor is driving or not
        
    public:
        // constructor takes 2 pins and the period
        motor(PinName pwm_pin, PinName dir_pin, double period);
        
        void drive(void);           // drives at set direction and duty cycle
        
        void stop(void);            // stops
        
        void setOut(double dc);     // set the output, number between -1 and 1
        
        double getPeriod(void);     // returns period
        
        double getDuty(void);       // returns dutycycle
};
 
 
 #endif