/* mbed Microcontroller Library
 * Copyright (c) 2006-2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <events/mbed_events.h>
#include <mbed.h>
#include "ble/BLE.h"
#include "ble/Gap.h"
#include "GattCallbackParamTypes.h"
#include "mbed.h"
#include "ColorService.h"
#include "BleDeviceCentral.h"
#include "BleDevicePeripheral.h"
#include "MyStripSingleton.h"
#define MBED_CONF_PLATFORM_ERROR_FILENAME_CAPTURE_ENABLED true
MyStripSingleton* MyStripSingleton::instance = 0;

int main()
{
    BLE& ble = BLE::Instance();
    events::EventQueue queue;
    printf(" Is filename capture enabled? \t\t");
    #if MBED_CONF_PLATFORM_ERROR_FILENAME_CAPTURE_ENABLED
    printf(" Enabled filename capture");
    #endif

    BleDevicePeripheral peripheral(ble, queue);
    BleDeviceCentral central(ble, queue);
    MyStripSingleton* inst = MyStripSingleton::getInstance();
    MyStripSingleton::getInstance()->colorWipe(1, 0x00FF00);

    MyStripSingleton::getInstance()->blink(10, 2);
    MyStripSingleton::getInstance()->flash(1, 0xFFFF00);

    while(1) {
        printf("\r\n PERIPHERAL \r\n\r\n");
        peripheral.run(15000);
        peripheral.stop();

        printf("\r\n CENTRAL \r\n\r\n");
        central.run(10000);
        central.stop();
    }
    return 0;
}

