//
// Created by kris on 13-6-19.
//

#ifndef SSS_BLE_MYSTRIPSINGLETON_H
#define SSS_BLE_MYSTRIPSINGLETON_H

#include "Adafruit_WS2801/Adafruit_WS2801.h"
#define STRIP_LENGTH 36
#define CLOCK_PIN p27
#define DATA_PIN p26

#pragma pack(push,1)
struct interests {
    uint32_t magic;
    uint32_t interest1;
    uint32_t interest2;
    uint32_t interest3;
    uint32_t interest4;
    uint32_t interest5;

};
#pragma pack(pop)s
class MyStripSingleton {
private:
    /* Here will be the instance stored. */
    static MyStripSingleton* instance;
    int crawlingLed;
    int crawlingLedOldColor;

    /* Private constructor to prevent instancing. */
    MyStripSingleton();
public:
    interests ints;
    /* Static access method. */
    static MyStripSingleton* getInstance();
    int ambientColor;
    Adafruit_WS2801 strip;
    uint32_t Color(uint8_t r, uint8_t g, uint8_t b);
    uint32_t Wheel(uint8_t WheelPos);
    void rainbow(uint8_t waittime);
    void rainbowCycle(uint8_t waittime);
    void colorWipe(uint8_t waittime, uint32_t c);
    void show();
    void solidColor(uint32_t c);
    void blink(int timeout, uint8_t amount);
    void crawlSingleLed(int timeout, uint32_t c);
    void resetColor();
    void flash(int timeout, uint32_t c);
    void connectionFlash();
    void crawlNextLed(int timeout, uint32_t c);
    void resetCrawl();
};


#endif //SSS_BLE_MYSTRIPSINGLETON_H
