//
// Created by kris on 13-6-19.
//
#include "MyStripSingleton.h"
//            strip(),

MyStripSingleton::MyStripSingleton() : strip(Adafruit_WS2801(STRIP_LENGTH, DATA_PIN,CLOCK_PIN, WS2801_RGB)) {
    //TODO: Make the strip
    ambientColor = 0x00ff00;
    strip.begin();
    strip.show();
}
uint32_t MyStripSingleton::Color(uint8_t r, uint8_t g, uint8_t b)
{
    uint32_t c;
    c = r;
    c <<= 8;
    c |= g;
    c <<= 8;
    c |= b;
    return c;
}

uint32_t MyStripSingleton::Wheel(uint8_t WheelPos)
{
    if (WheelPos < 85) {
        return Color(WheelPos * 3, 255 - WheelPos * 3, 0);
    } else if (WheelPos < 170) {
        WheelPos -= 85;
        return Color(255 - WheelPos * 3, 0, WheelPos * 3);
    } else {
        WheelPos -= 170;
        return Color(0, WheelPos * 3, 255 - WheelPos * 3);
    }
}
// Slightly different, this one makes the rainbow wheel equally distributed
// along the chain
void MyStripSingleton::rainbowCycle(uint8_t waittime) {
    int i, j;
    for (j=0; j < 256; j++) {     // 5 cycles of all 25 colors in the wheel
        for (i=0; i < strip.numPixels(); i++) {
            strip.setPixelColor(i, Wheel( ((i * 256 / strip.numPixels()) + j) % 256) );
        }
        strip.show();   // write all the pixels out
        wait_ms(waittime);
    }
    resetColor();
}
void MyStripSingleton::solidColor(uint32_t c) {
    for (int z= STRIP_LENGTH; z >= 0 ; z--) {
        strip.setPixelColor(z, c);
    }
    show();
}

void MyStripSingleton::show() {
    strip.show();
}
void MyStripSingleton::colorWipe(uint8_t waittime, uint32_t c) {
    int i;

    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, c);
        strip.show();
        wait_ms(waittime);
    }
}

void MyStripSingleton::flash(int timeout, uint32_t c) {
    int targetColor = c;
    if(strip.getPixelColor(0) == 0){
        targetColor = 0xFFFFFF;
    }
    uint32_t oldPixels[strip.numPixels()];
    for (int i=0; i < strip.numPixels(); i++) {

        oldPixels[i] = strip.getPixelColor(i);
        strip.setPixelColor(i, targetColor);
    }
    wait_ms(timeout);
    show();
    for (int i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, oldPixels[i]);
    }
    wait_ms(timeout);
    show();
}
void MyStripSingleton::blink(int timeout, uint8_t amount) {
    int targetColor = 0;
    if(strip.getPixelColor(0) == 0){
        targetColor = 0xFFFFFF;
    }
    uint32_t oldPixels[strip.numPixels()];
    for (int i=0; i < strip.numPixels(); i++) {

        oldPixels[i] = strip.getPixelColor(i);
        strip.setPixelColor(i, targetColor);
    }
    show();
    wait_ms(timeout);
    for (int i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, oldPixels[i]);
    }
    show();

    if(amount > 1){
        for (int a=1; a <= amount; a++) {
            for (int i=0; i < strip.numPixels(); i++) {
                strip.setPixelColor(i, targetColor);
            }
            show();
            wait_ms(timeout);
            for (int i=0; i < strip.numPixels(); i++) {
                strip.setPixelColor(i, oldPixels[i]);
            }
            show();
        }
    }
}

void MyStripSingleton::crawlNextLed(int timeout, uint32_t c) {
    if(crawlingLed > 0){
        //Als er een ledje eerder is geweest reset naar oude kleur
        strip.setPixelColor(crawlingLed -1, crawlingLedOldColor);
    } else if(crawlingLed == 0 && crawlingLedOldColor != 0){
        //Als het vorige ledje de laatste was, reset de laatste
        strip.setPixelColor(STRIP_LENGTH -1, crawlingLedOldColor);
    }
    //Oude kleur onthouden van de nieuwe crawler
    crawlingLedOldColor = strip.getPixelColor(crawlingLed);
    strip.setPixelColor(crawlingLed, c);
    strip.show();
    wait_ms(timeout);
    crawlingLed++;
    if(crawlingLed == STRIP_LENGTH){
        crawlingLed = 0;
    }
}
void MyStripSingleton::resetCrawl(){
    if(crawlingLed == 0){
        crawlingLed = STRIP_LENGTH;
    }
    strip.setPixelColor(crawlingLed -1, crawlingLedOldColor);
    crawlingLedOldColor = 0;
    crawlingLed = 0;
    strip.show();
}
void MyStripSingleton::crawlSingleLed(int timeout, uint32_t c) {
    uint32_t oldcolor = 0;
    for (int i=0; i < strip.numPixels(); i++) {
        if(i > 0){
            strip.setPixelColor(i -1, oldcolor);
        }
        oldcolor = strip.getPixelColor(i);
        strip.setPixelColor(i, c);
        wait_ms(timeout);
        show();

    }
}
void MyStripSingleton::resetColor(){
    int i;
    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, ambientColor);
    }
    strip.show();
}
void MyStripSingleton::connectionFlash() {
    flash(100, 0XFF0000);
    flash(100, 0XFF0000);
    flash(100, 0XFF0000);
    flash(100, 0XFF0000);
}
MyStripSingleton *MyStripSingleton::getInstance() {
    if(!instance ){
        instance = new MyStripSingleton();
    }
    return instance;
}
