//
// Created by kris on 7-5-19.
//

#include <wait_api.h>
#include "InterestService.h"

#include "FlashIAP.h"
#include "MyStripSingleton.h"

uint32_t sector_size;
uint32_t page_size;
uint32_t prog_size;
uint32_t address;
mbed::FlashIAP flash_device;

#pragma pack(push,1)
struct packed_A {
    uint32_t magic;
    uint32_t interest1;
    uint32_t interest2;
    uint32_t interest3;
    uint32_t interest4;
    uint32_t interest5;

};
#pragma pack(pop)
enum { MAGIC_VALUE = 0xC0FFEE };

InterestService::InterestService(BLE& _ble) :
        ble(_ble),
        interestCharacteristic( (UUID)CustomUUIDs::UUID_INTEREST_CHAR,
                                &interests,
                                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NONE)
{
    printf("[PERIPHERAL] Adding interest service.. \r\n");
    GattCharacteristic *charTable[] = { &interestCharacteristic };

    GattService interestService(
            CustomUUIDs::UUID_INTEREST_SERVICE,
            charTable,
            sizeof(charTable) / sizeof(GattCharacteristic *));
    ble.gattServer().addService(interestService);
    ble.gattServer().onDataWritten(this, &InterestService::onDataWritten);
    readFromFs();
}

bool initializeDevice()
{
    return flash_device.init() == 0;
}

void determineValues()
{
    sector_size = flash_device.get_sector_size(flash_device.get_flash_start() + flash_device.get_flash_size() - 1UL);
    page_size = flash_device.get_page_size();
    address = (flash_device.get_flash_start() + flash_device.get_flash_size()) - (sector_size);
    printf("[PERIPHERAL]\t Sector size: %d \r\n", sector_size);
    printf("[PERIPHERAL]\t Page size: %d \r\n", page_size);
    printf("[PERIPHERAL]\t Address: %d \r\n", address);
}
void InterestService::onDataWritten(const GattWriteCallbackParams *writeParams) {
    //TODO: You gave me some data... Let's store it!
    uint16_t handle = writeParams->handle;
    printf("[PERIPHERAL]\t You wrote some data... But for which char? \r\n");
    printf("%d == %d", handle, interestCharacteristic.getValueHandle());//colorCharacteristic.getValueHandle());
    if(handle == 6 || handle == 16 || handle == interestCharacteristic.getValueHandle()){
        printf("[PERIPHERAL]\t You wrote interests!");
        printf("[PERIPHERAL]\t The value should be an array of 5 integers.");
//            color = writeParams->data;
        int index = 0;
        for (int i=0; i < 20;  i++) {
            interests[i] = writeParams->data[i];
            index++;
            printf("[PERIPHERAL]\t Index: %d, val %08X \r\n", index, interests[i]);
        }
        printf("[PERIPHERAL]\t Writing that to the FS..\r\n");
        writeToFs();
    }
}


int InterestService::readFromFs() {
    if(initializeDevice()){
        determineValues();


        uint8_t *data_flashed = new uint8_t[24];
        uint8_t buffer[24];
        flash_device.read(buffer, address, 24);
        packed_A const *ptr = (packed_A const *) buffer;
//        printf("%d", ptr->magic);

        if(ptr->magic == MAGIC_VALUE) {
            printf("[PERIPHERAL]\t Address initialized, current magic %6x \r\n", ptr->magic);
            printf("[PERIPHERAL]\t Address initialized, current list %lx,%lx,%lx,%lx,%lx \r\n",
                   ptr->interest1,
                   ptr->interest2,
                   ptr->interest3,
                   ptr->interest4,
                   ptr->interest5);

            interests[0] = ptr->interest1;
            interests[1] = ptr->interest2;
            interests[2] = ptr->interest3;
            interests[3] = ptr->interest4;
            interests[4] = ptr->interest5;
            ble.gattServer().write(interestCharacteristic.getValueHandle(), (uint8_t *) &interests, sizeof(interests_T));

            printf("[PERIPHERAL]\t Interests should now be set to: %8x,%8x,%8x,%8x,%8x \r\n",
                   interests[0],
                   interests[1],
                   interests[2],
                   interests[3],
                   interests[4]
            ) ;
            MyStripSingleton::getInstance()->ints.interest1     = ptr->interest1;
            MyStripSingleton::getInstance()->ints.interest2     = ptr->interest2;
            MyStripSingleton::getInstance()->ints.interest3     = ptr->interest3;
            MyStripSingleton::getInstance()->ints.interest4     = ptr->interest4;
            MyStripSingleton::getInstance()->ints.interest5     = ptr->interest5;


            printf("[PERIPHERAL]\t Interest 1: %d %6x \r\n", MyStripSingleton::getInstance()->ints.interest1 >> 24, MyStripSingleton::getInstance()->ints.interest1);
            printf("[PERIPHERAL]\t Interest 2: %d %8x \r\n", MyStripSingleton::getInstance()->ints.interest2 >> 24, MyStripSingleton::getInstance()->ints.interest2 );
            printf("[PERIPHERAL]\t Interest 3: %d %8x \r\n", MyStripSingleton::getInstance()->ints.interest3 >> 24, MyStripSingleton::getInstance()->ints.interest3 );
            printf("[PERIPHERAL]\t Interest 4: %d %8x \r\n", MyStripSingleton::getInstance()->ints.interest4 >> 24, MyStripSingleton::getInstance()->ints.interest4 );
            printf("[PERIPHERAL]\t Interest 5: %d %8x \r\n", MyStripSingleton::getInstance()->ints.interest5 >> 24, MyStripSingleton::getInstance()->ints.interest5 );
        } else {
            printf("[PERIPHERAL]\t Uninitialized, setting up first time");
            packed_A newmemory;
            newmemory.magic = MAGIC_VALUE;
            newmemory.interest1 = 0UL;
            newmemory.interest2 = 0UL;
            newmemory.interest3 = 0UL;
            newmemory.interest4 = 0UL;
            newmemory.interest5 = 0UL;
            interests[0] = 0;
            interests[1] = 0;
            interests[2] = 0;
            interests[3] = 0;
            interests[4] = 0;
            ble.gattServer().write(interestCharacteristic.getValueHandle(), (uint8_t *) &interests, sizeof(interests_T));

            flash_device.erase(address, flash_device.get_sector_size(address));
            flash_device.program(&newmemory, address, flash_device.get_sector_size(address));
            printf("[PERIPHERAL]\t Flashed for the first time.");
        }
        return 0;
    } else {
        printf("[PERIPHERAL]\t Couldn't init fs. \r\n");
        return -1;
    }
}


int InterestService::writeToFs() {
    mbed::FlashIAP flash_device;
    flash_device.init();
    printf("[PERIPHERAL]\t Inited FS.. \r\n");
    packed_A newmemory;
    int sector_size = flash_device.get_sector_size(flash_device.get_flash_start() + flash_device.get_flash_size() - 1UL);
    int page_size = flash_device.get_page_size();
    int address = (flash_device.get_flash_start() + flash_device.get_flash_size()) - (sector_size);
    printf("[PERIPHERAL]\t Ready?\r\n");

    newmemory.magic = MAGIC_VALUE;
    newmemory.interest1 = int((unsigned char)(    interests[0]) << 24|
                              (unsigned char)(    interests[1]) << 16 |
                              (unsigned char)(    interests[2]) << 8 |
                              (unsigned char)(    interests[3]));
    newmemory.interest2 = int((unsigned char)(    interests[4]) << 24|
                              (unsigned char)(    interests[5]) << 16 |
                              (unsigned char)(    interests[6]) << 8 |
                              (unsigned char)(    interests[7]));
    newmemory.interest3 = int((unsigned char)(    interests[8]) << 24|
                              (unsigned char)(    interests[9]) << 16 |
                              (unsigned char)(    interests[10]) << 8 |
                              (unsigned char)(    interests[11]));
    newmemory.interest4 = int((unsigned char)(    interests[12]) << 24|
                              (unsigned char)(    interests[13]) << 16 |
                              (unsigned char)(    interests[14]) << 8 |
                              (unsigned char)(    interests[15]));
    newmemory.interest5 = int((unsigned char)(    interests[16]) << 24|
                              (unsigned char)(    interests[17]) << 16 |
                              (unsigned char)(    interests[18]) << 8 |
                              (unsigned char)(    interests[19]));
    printf("[PERIPHERAL]\t Mem is now: %d \r\n", newmemory.interest1 );//interests[i]);
    printf("[PERIPHERAL]\t Mem is now: %d \r\n", newmemory.interest2 );//interests[i]);
    printf("[PERIPHERAL]\t Mem is now: %d \r\n", newmemory.interest3 );//interests[i]);
    printf("[PERIPHERAL]\t Mem is now: %d \r\n", newmemory.interest4 );//interests[i]);
    printf("[PERIPHERAL]\t Mem is now: %d \r\n", newmemory.interest5 );//interests[i]);


    printf("[PERIPHERAL]\t %d\r\n", sizeof(newmemory));
    printf("[PERIPHERAL]\t %d\r\n", address);
    printf("[PERIPHERAL]\t %d\r\n", sizeof(interests));

    flash_device.erase(address, flash_device.get_sector_size(address));
    wait(0.2);
    int result = flash_device.program(&newmemory, address, flash_device.get_sector_size(address));
    printf("[PERIPHERAL]\t Flashed with result %d \r\n", result);
    readFromFs();

    return 0;
}

int InterestService::createFs(){
    return true;
}

InterestService::~InterestService() {
    printf("[PERIPHERAL]\t Destructing InterestService\r\n");
}