#ifndef __BLE_COLOR_SERVICE_H__
#define __BLE_COLOR_SERVICE_H__

#include "ble/BLE.h"
#include "CustomUUIDs.h"
#include "MyStripSingleton.h"


class ColorService {
public:
    /**
     * @brief   ColorService constructor.
     * @param   ble Reference to BLE device.
     */
    typedef uint32_t ColorType_t;
    ColorService(BLE& _ble) :
            ble(_ble),
            colorCharacteristic((UUID)CustomUUIDs::UUID_COLOR_CHAR, &color)
    {
        static bool serviceAdded = false; /* We should only ever need to add the information service once. */
        if (serviceAdded) {
            return;
        }
        printf("[PERIPHERAL] Adding service.. \r\n");
        GattCharacteristic *charTable[] = { &colorCharacteristic };

        GattService colorService(
                CustomUUIDs::UUID_COLOR_SERVICE,
                charTable,
                sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(colorService);

        ble.gattServer().onDataWritten(this, &ColorService::onDataWritten);
    }

    virtual ~ColorService() {
        printf("[PERIPHERAL]\t Destructing ColorService");
    }

    virtual void onDataWritten(const GattWriteCallbackParams *writeParams) {
        uint16_t handle = writeParams->handle;
        printf("You wrote some data... But for which char? \r\n");
        printf("%d == %d", handle, colorCharacteristic.getValueHandle());//colorCharacteristic.getValueHandle());
        if(handle == colorCharacteristic.getValueHandle()){
            printf("[PERIPHERAL]\t You wrote a color! \r\n");
            printf("[PERIPHERAL]\t The value should be an integer.\r\n");
            color = (unsigned  char)writeParams->data[0] << 16 | writeParams->data[1] << 8 | writeParams->data[2];
            printf("[PERIPHERAL]\t Setting color %06X\n\r", color);

            MyStripSingleton::getInstance()->ambientColor = color;
            MyStripSingleton::getInstance()->solidColor(color);
        }
        printf("[PERIPHERAL]\t Did that work?\n\r");
    }
private:
    BLE& ble;
    ColorType_t color;
    ReadWriteGattCharacteristic<ColorType_t>    colorCharacteristic;
};
#endif /* #ifndef __BLE_COLOR_SERVICE_H__*/