#include "BleDevicePeripheral.h"

void BleDevicePeripheral::onConnectionComplete(const ble::ConnectionCompleteEvent &event) {
    printf("[PERIPHERAL]\t Connected to peer: ");
    print_address(event.getPeerAddress().data());
    _handle = event.getConnectionHandle();
    printf("[PERIPHERAL]\t I'm connected to someone, what should i do now?");

    //Dispatch forever makes sure that we stay in this state until explicitly told otherwise (on disconnect).
    _event_queue.dispatch_forever();

}

void BleDevicePeripheral::stop() {
    printf("[PERIPHERAL]\t Stopping \r\n");
    _ble.gap().stopAdvertising(ble::LEGACY_ADVERTISING_HANDLE);
    delete cs;
    delete is;
    MyStripSingleton::getInstance()->resetColor();
    if (_ble.hasInitialized()) {
        _ble.shutdown();
    }
}

BleDevicePeripheral::~BleDevicePeripheral() {
    printf("[PERIPHERAL]\t Destructing the peripheral\r\n");
}

void BleDevicePeripheral::start() {

    ble_error_t error;
    /* Set up and start advertising */
    uint8_t adv_buffer[ble::LEGACY_ADVERTISING_MAX_SIZE];
    /* use the helper to build the payload */
    ble::AdvertisingDataBuilder adv_data_builder(
            adv_buffer
    );

    adv_data_builder.setFlags();
    adv_data_builder.setName("SSS BLE", true);
    ble::AdvertisingParameters adv_parameters(
            ble::advertising_type_t::CONNECTABLE_UNDIRECTED,
            ble::adv_interval_t(ble::millisecond_t(50))
    );

    error = _ble.gap().setAdvertisingParameters(
            ble::LEGACY_ADVERTISING_HANDLE,
            adv_parameters
    );
    if (error) {
        print_error(error, "[PERIPHERAL]\t Gap::setAdvertisingParameters() failed");
        return;
    }
    /* Set payload for the set */
    error = _ble.gap().setAdvertisingPayload(
            ble::LEGACY_ADVERTISING_HANDLE,
            adv_data_builder.getAdvertisingData()
    );

    if (error) {
        print_error(error, "Gap::setAdvertisingPayload() failed");
        _event_queue.break_dispatch();
        return;
    }



    cs = new ColorService(_ble);
    is = new InterestService(_ble);
    printf("[PERIPHERAL]\t Starting advertising \r\n");

    error = _ble.gap().startAdvertising(ble::LEGACY_ADVERTISING_HANDLE);

    if (error) {
        print_error(error, "[PERIPHERAL]\t Gap::startAdvertising() failed");
        return;
    }

    printf("[PERIPHERAL]\t Set up BLE. I should now be advertising \r\n");
    printf("[PERIPHERAL]\t Please connect a device\r\n");
}

BleDevicePeripheral::BleDevicePeripheral(const BLE &ble, EventQueue &eventQueue)
        : BleDevice(ble, eventQueue){
}
