//
// Created by kris on 20-4-19.
//

#ifndef SSS_BLE_BLEDEVICECENTRAL_H
#define SSS_BLE_BLEDEVICECENTRAL_H

#include <AdvertisingDataParser.h>
#include "BleDevice.h"


#include "list"
#include "MyStripSingleton.h"

class BleDeviceCentral : public BleDevice {
public:
    BleDeviceCentral(BLE &ble, events::EventQueue &event_queue)
            : BleDevice(ble, event_queue) {

    }
    std::list<ble::address_t::byte_array_t> addresses ;

    virtual void start()
    {
        printf("[CENTRAL]\t Scan started\r\n");
        MyStripSingleton::getInstance()->resetCrawl();
        ble::ScanParameters params;
        ble_error_t error = _ble.gap().setScanParameters(params);

        if (error) {
            print_error(error, "Error in Gap::startScan %d\r\n");
            return;
        }
        error = _ble.gap().startScan();

        if (error) {
            print_error(error, "Error in Gap::startScan %d\r\n");
            return;
        }

    }
    virtual void stop(){
        printf("[CENTRAL]\t Stopping \r\n");
        MyStripSingleton::getInstance()->resetColor();

        addresses.clear();
        _ble.gap().stopScan();
        if (_ble.hasInitialized()) {
            _ble.shutdown();
        }
    }

public:
    /** Look at scan payload to find a peer device and connect to it */
    virtual void onAdvertisingReport(const ble::AdvertisingReportEvent &event);
};


#endif //SSS_BLE_BLEDEVICECENTRAL_H
