//
// Created by kris on 20-4-19.
//

#include "BleDeviceCentral.h"

void hubDetection(){
    MyStripSingleton::getInstance()->rainbowCycle(2);
}

void BleDeviceCentral::onAdvertisingReport(const ble::AdvertisingReportEvent &event) {
    {

        /* don't bother with analysing scan result if we're already connecting */
        if (_is_connecting) {
            return;
        }
        bool found = false;
        ble::address_t::byte_array_t actualdata = event.getPeerAddress().data();

        //TODO: Start service discovery.
        ble::AdvertisingDataParser adv_data(event.getPayload());
        while (adv_data.hasNext()) {
            if (addresses.size() > 0) {
                found = (std::find(addresses.begin(), addresses.end(), actualdata) != addresses.end());
            }

            if (!found) {
                //TODO: Clear the list to prevent memory overflow
                addresses.push_back(actualdata);
                MyStripSingleton::getInstance()->crawlNextLed(1, 0xFF00FF);

                printf("\r\n Amount devices: %d \r\n", addresses.size());
                return;
            } else {
//            TODO: Increment internal counter
            }
//            printf("\n\t\t Has next");
            ble::AdvertisingDataParser::element_t field = adv_data.next();

            /* connect to a discoverable device */
            //Deze if-statement kijkt naar de naam en MEMCMP vergelijkt de advertising-naam met de target-naam (sssble)
            //Als het SSS BLE is, moet ik dus de services gaan ontdekken en de interest-service uitlezen. Dit is altijd een array van 5 bytes, allemaal
            /*if (field.type == ble::adv_data_type_t::COMPLETE_LOCAL_NAME &&
                field.value.size() == strlen("SSS BLE") &&
                (memcmp(field.value.data(), "SSS BLE", field.value.size()) == 0)) {*/
            if (field.type == ble::adv_data_type_t::COMPLETE_LOCAL_NAME) {
                if (field.type == ble::adv_data_type_t::COMPLETE_LOCAL_NAME &&
                    field.value.size() == strlen("SSS BLE") &&
                    (memcmp(field.value.data(), "SSS BLE", field.value.size()) == 0)) {

                    printf("[CENTRAL]\t Found another wearable, let's try connecting to him.\r\n");
                    MyStripSingleton::getInstance()->resetCrawl();
//                    wait_ms(200);
                    ble_error_t error = _ble.gap().stopScan();

                    if (error) {
                        print_error(error, "Error caused by Gap::stopScan");
                        return;
                    }
                    printf("[CENTRAL]\t Stopped the scan.\r\n");

                    const ble::ConnectionParameters connection_params;

                    printf("[CENTRAL]\t Trying to connect.\r\n");

                    error = _ble.gap().connect(
                            event.getPeerAddressType(),
                            event.getPeerAddress(),
                            connection_params
                    );
                    printf("[CENTRAL]\t Trying to connect..\r\n");

                    if (error) {
                        _ble.gap().startScan();
                        return;
                    }
                    printf("[CENTRAL]\t Looks like I'm connected...\r\n");
                    //TODO: Break the event queue, but keep doing what im doing
                    _event_queue.dispatch_forever();
                }

                char test[field.value.size()];
                char GoogleHome[field.value.size()];
                char *output = NULL;
                output = strstr (test, "GoogleHome");
                memcpy(test, field.value.data(), field.value.size());
                //TODO: If name contains something like google home, do fancy shit but keep it at that
                if (output) {
                    // do stuff
                    printf("There seems to be a google home nearby!");
                    MyStripSingleton::getInstance()->rainbowCycle(2);
                    _event_queue.call(callback(hubDetection));

                }

                printf("\n\t\t Adv from: ");
                printf("%s", test);
                printf(" rssi: %d, scan response: %u, connectable: %u\r\n",
                       event.getRssi(), event.getType().scan_response(), event.getType().connectable());


                /* we may have already scan events waiting
                 * to be processed so we need to remember
                 * that we are already connecting and ignore them */
//                _is_connecting = true;

                return;
            }
        }

    }
}
